/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime;

import com.sun.istack.FinalArrayList;
import com.sun.istack.SAXException2;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.glassfish.jaxb.runtime.v2.runtime.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ContentHandlerAdaptor
extends DefaultHandler {
    private final FinalArrayList<String> prefixMap = new FinalArrayList();
    private final XMLSerializer serializer;
    private final StringBuffer text = new StringBuffer();

    ContentHandlerAdaptor(XMLSerializer _serializer) {
        this.serializer = _serializer;
    }

    @Override
    public void startDocument() {
        this.prefixMap.clear();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap.add(prefix);
        this.prefixMap.add(uri);
    }

    private boolean containsPrefixMapping(String prefix, String uri) {
        for (int i2 = 0; i2 < this.prefixMap.size(); i2 += 2) {
            if (!((String)this.prefixMap.get(i2)).equals(prefix) || !((String)this.prefixMap.get(i2 + 1)).equals(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            int i2;
            this.flushText();
            int len = atts.getLength();
            String p = this.getPrefix(qName);
            if (this.containsPrefixMapping(p, namespaceURI)) {
                this.serializer.startElementForce(namespaceURI, localName, p, null);
            } else {
                this.serializer.startElement(namespaceURI, localName, p, null);
            }
            for (i2 = 0; i2 < this.prefixMap.size(); i2 += 2) {
                this.serializer.getNamespaceContext().force((String)this.prefixMap.get(i2 + 1), (String)this.prefixMap.get(i2));
            }
            for (i2 = 0; i2 < len; ++i2) {
                String qname = atts.getQName(i2);
                if (qname.startsWith("xmlns") || atts.getURI(i2).length() == 0) continue;
                String prefix = this.getPrefix(qname);
                this.serializer.getNamespaceContext().declareNamespace(atts.getURI(i2), prefix, true);
            }
            this.serializer.endNamespaceDecls(null);
            for (i2 = 0; i2 < len; ++i2) {
                if (atts.getQName(i2).startsWith("xmlns")) continue;
                this.serializer.attribute(atts.getURI(i2), atts.getLocalName(i2), atts.getValue(i2));
            }
            this.prefixMap.clear();
            this.serializer.endAttributes();
        }
        catch (IOException | XMLStreamException e) {
            throw new SAXException2(e);
        }
    }

    private String getPrefix(String qname) {
        int idx = qname.indexOf(58);
        return idx == -1 ? "" : qname.substring(0, idx);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.flushText();
            this.serializer.endElement();
        }
        catch (IOException | XMLStreamException e) {
            throw new SAXException2(e);
        }
    }

    private void flushText() throws SAXException, IOException, XMLStreamException {
        if (this.text.length() != 0) {
            this.serializer.text(this.text.toString(), null);
            this.text.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.append(ch, start, length);
    }
}

