/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.jaxb;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.springframework.core.MethodParameter;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.jaxb.AbstractJaxb2PayloadMethodProcessor;

public class XmlRootElementPayloadMethodProcessor
extends AbstractJaxb2PayloadMethodProcessor {
    @Override
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        Class<?> parameterType = parameter.getParameterType();
        return parameterType.isAnnotationPresent(XmlRootElement.class) || parameterType.isAnnotationPresent(XmlType.class);
    }

    @Override
    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) throws JAXBException {
        Class<?> parameterType = parameter.getParameterType();
        if (parameterType.isAnnotationPresent(XmlRootElement.class)) {
            return this.unmarshalFromRequestPayload(messageContext, parameterType);
        }
        JAXBElement<?> element = this.unmarshalElementFromRequestPayload(messageContext, parameterType);
        return element != null ? element.getValue() : null;
    }

    @Override
    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        Class<?> parameterType = returnType.getParameterType();
        return parameterType.isAnnotationPresent(XmlRootElement.class);
    }

    @Override
    protected void handleReturnValueInternal(MessageContext messageContext, MethodParameter returnType, Object returnValue) throws JAXBException {
        Class<?> parameterType = returnType.getParameterType();
        this.marshalToResponsePayload(messageContext, parameterType, returnValue);
    }
}

