/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.client.core;

import java.io.IOException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.SoapMessage;

public class SoapActionCallback
implements WebServiceMessageCallback {
    private final String soapAction;

    public SoapActionCallback(String soapAction) {
        if (!StringUtils.hasText(soapAction)) {
            soapAction = "\"\"";
        }
        this.soapAction = soapAction;
    }

    @Override
    public void doWithMessage(WebServiceMessage message) throws IOException {
        Assert.isInstanceOf(SoapMessage.class, message);
        SoapMessage soapMessage = (SoapMessage)message;
        soapMessage.setSoapAction(this.soapAction);
    }
}

