/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.ClientHttpRequestConnection;

public class ClientHttpRequestMessageSender
extends AbstractHttpWebServiceMessageSender {
    private ClientHttpRequestFactory requestFactory;

    public ClientHttpRequestMessageSender() {
        this(new SimpleClientHttpRequestFactory());
    }

    public ClientHttpRequestMessageSender(ClientHttpRequestFactory requestFactory) {
        this.setRequestFactory(requestFactory);
    }

    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, "'requestFactory' must not be null");
        this.requestFactory = requestFactory;
    }

    @Override
    public WebServiceConnection createConnection(URI uri) throws IOException {
        ClientHttpRequest request = this.requestFactory.createRequest(uri, HttpMethod.POST);
        if (this.isAcceptGzipEncoding()) {
            request.getHeaders().add("Accept-Encoding", "gzip");
        }
        return new ClientHttpRequestConnection(request);
    }
}

