/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.function.BiFunction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.RegexFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class Replace
extends RegexFunction {
    private int version = 20;
    private boolean replacementChecked = false;

    public static Replace make20() {
        Replace rep = new Replace();
        rep.version = 20;
        return rep;
    }

    public static Replace make40() {
        Replace rep = new Replace();
        rep.version = 40;
        return rep;
    }

    @Override
    protected boolean allowRegexMatchingEmptyString() {
        return false;
    }

    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        UnicodeString rep;
        boolean doEarlyReplacementCheck = true;
        if (arguments.length >= 4) {
            if (arguments[3] instanceof StringLiteral) {
                String flags = ((StringLiteral)arguments[3]).stringify();
                if (flags.contains("q") || flags.contains(";")) {
                    doEarlyReplacementCheck = false;
                }
            } else {
                doEarlyReplacementCheck = false;
            }
        }
        if (arguments[2] instanceof StringLiteral && doEarlyReplacementCheck && Replace.checkReplacement(rep = ((StringLiteral)arguments[2]).getString()) == null) {
            this.replacementChecked = true;
        }
        return super.makeFunctionCall(arguments);
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        String msg;
        FunctionItem actionFn;
        UnicodeString replacement;
        StringValue arg0 = (StringValue)arguments[0].head();
        UnicodeString input = arg0 == null ? EmptyUnicodeString.getInstance() : arg0.getUnicodeStringValue();
        RegularExpression re = this.getRegularExpression(arguments, 1, 3);
        Item replacementArg = arguments[2].head();
        UnicodeString unicodeString = replacement = replacementArg == null ? null : replacementArg.getUnicodeStringValue();
        if (replacement == null && this.version == 20) {
            throw new XPathException("Third argument of fn:replace() must not be empty").withErrorCode("XPTY0004").asTypeError();
        }
        BiFunction<UnicodeString, UnicodeString[], UnicodeString> action = null;
        if (arguments.length == 5 && (actionFn = (FunctionItem)arguments[4].head()) != null) {
            action = (in, groups) -> {
                try {
                    ArrayList<StringValue> groupItems = new ArrayList<StringValue>(((UnicodeString[])groups).length);
                    for (UnicodeString group : groups) {
                        groupItems.add(new StringValue(group, (AtomicType)BuiltInAtomicType.UNTYPED_ATOMIC));
                    }
                    Sequence result = actionFn.call(context, new Sequence[]{new StringValue((UnicodeString)in, (AtomicType)BuiltInAtomicType.UNTYPED_ATOMIC), SequenceExtent.makeSequenceExtent(groupItems)});
                    Item resultItem = result.head();
                    if (resultItem == null) {
                        return EmptyUnicodeString.getInstance();
                    }
                    return resultItem.getUnicodeStringValue();
                }
                catch (XPathException e) {
                    throw new AssertionError((Object)e);
                }
            };
        }
        if (replacement != null && action != null) {
            throw new XPathException("Cannot supply both a replacement string and a replacement action", "FORX0005");
        }
        if (!(replacement == null || this.replacementChecked || re.getFlags().contains("q") || re.isPlatformNative() || (msg = Replace.checkReplacement(replacement)) == null)) {
            throw new XPathException(msg, "FORX0004", context);
        }
        if (replacement != null) {
            return new StringValue(re.replace(input, replacement));
        }
        if (action != null) {
            return new StringValue(re.replaceWith(input, action));
        }
        return new StringValue(re.replace(input, EmptyUnicodeString.getInstance()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkReplacement(UnicodeString rep) {
        int i2 = 0;
        while ((long)i2 < rep.length()) {
            int index;
            int next;
            int c = rep.codePointAt(i2);
            if (c == 36) {
                if ((long)(i2 + 1) >= rep.length()) return "Invalid replacement string in replace(): $ sign at end of string";
                if ((next = rep.codePointAt(index = ++i2)) < 48 || next > 57) {
                    return "Invalid replacement string in replace(): $ sign must be followed by digit 0-9";
                }
            } else if (c == 92) {
                if ((long)(i2 + 1) >= rep.length()) return "Invalid replacement string in replace(): \\ character at end of string";
                if ((next = rep.codePointAt(index = ++i2)) != 92 && next != 36) {
                    return "Invalid replacement string in replace(): \\ character must be followed by \\ or $";
                }
            }
            ++i2;
        }
        return null;
    }
}

