/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSingletonIterator;

public class OpBackReference
extends Operation {
    int groupNr;

    OpBackReference(int groupNr) {
        this.groupNr = groupNr;
    }

    @Override
    public int matchesEmptyString() {
        return 0;
    }

    @Override
    public IntIterator iterateMatches(REMatcher matcher, int position) {
        int s = matcher.startBackref[this.groupNr];
        int e = matcher.endBackref[this.groupNr];
        if (s == -1 || e == -1) {
            return EmptyIntIterator.getInstance();
        }
        if (s == e) {
            return new IntSingletonIterator(position);
        }
        int l = e - s;
        UnicodeString search = matcher.search;
        if ((long)(position + l - 1) >= search.length()) {
            return EmptyIntIterator.getInstance();
        }
        if (matcher.program.flags.isCaseIndependent()) {
            for (int i2 = 0; i2 < l; ++i2) {
                if (matcher.equalCaseBlind(search.codePointAt(position + i2), search.codePointAt(s + i2))) continue;
                return EmptyIntIterator.getInstance();
            }
        } else {
            for (int i3 = 0; i3 < l; ++i3) {
                if (search.codePointAt(position + i3) == search.codePointAt(s + i3)) continue;
                return EmptyIntIterator.getInstance();
            }
        }
        return new IntSingletonIterator(position + l);
    }

    @Override
    public String display() {
        return "\\" + this.groupNr;
    }
}

