/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.util.Arrays;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.z.ConcatenatingIntIterator;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntRepeatIterator;

public class IndentWhitespace
extends WhitespaceString {
    private final int newlines;
    private final int spaces;

    private IndentWhitespace(int newlines, int spaces) {
        this.newlines = newlines;
        this.spaces = spaces;
    }

    public static IndentWhitespace of(int newlines, int spaces) {
        return new IndentWhitespace(newlines, spaces);
    }

    @Override
    public UnicodeString uncompress() {
        byte[] bytes = new byte[this.newlines + this.spaces];
        Arrays.fill(bytes, 0, this.newlines, (byte)10);
        Arrays.fill(bytes, this.newlines, this.newlines + this.spaces, (byte)32);
        return new Twine8(bytes);
    }

    @Override
    public long length() {
        return this.newlines + this.spaces;
    }

    @Override
    public int length32() {
        return this.newlines + this.spaces;
    }

    public int getNewlines() {
        return this.newlines;
    }

    public int getSpaces() {
        return this.spaces;
    }

    @Override
    public int codePointAt(long index) {
        if (index >= 0L && index < (long)this.newlines) {
            return 10;
        }
        if (index <= (long)(this.newlines + this.spaces)) {
            return 32;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IntIterator codePoints() {
        return new ConcatenatingIntIterator(new IntRepeatIterator(10, this.newlines), () -> new IntRepeatIterator(32, this.spaces));
    }

    @Override
    public String toString() {
        char[] chars = new char[this.newlines + this.spaces];
        Arrays.fill(chars, 0, this.newlines, '\n');
        Arrays.fill(chars, this.newlines, this.newlines + this.spaces, ' ');
        return new String(chars);
    }

    @Override
    public void write(UnicodeWriter writer) throws IOException {
        if (this.newlines > 0) {
            writer.writeRepeatedAscii((byte)10, this.newlines);
        }
        if (this.spaces > 0) {
            writer.writeRepeatedAscii((byte)32, this.spaces);
        }
    }

    @Override
    public void writeEscape(boolean[] specialChars, UnicodeWriter writer) throws IOException {
        if (specialChars[10]) {
            for (int i2 = 0; i2 < this.newlines; ++i2) {
                writer.writeAscii(StringConstants.ESCAPE_NL);
            }
        } else {
            writer.writeRepeatedAscii((byte)10, this.newlines);
        }
        writer.writeRepeatedAscii((byte)32, this.spaces);
    }
}

