/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.Arrays;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.CompressedWhitespace;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.Twine16;
import net.sf.saxon.str.Twine24;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntIterator;

public class StringTool {
    public static int getStringLength(CharSequence s) {
        int n = 0;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public static int[] expand(UnicodeString s) {
        int[] array = new int[s.length32()];
        s.copy32bit(array, 0);
        return array;
    }

    public static boolean containsSurrogates(CharSequence str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (!UTF16CharacterSet.isSurrogate(str.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static UnicodeString fromCodePoints(int[] codes, int used) {
        UnicodeBuilder sb = new UnicodeBuilder();
        for (int i2 = 0; i2 < used; ++i2) {
            sb.append(codes[i2]);
        }
        return sb.toUnicodeString();
    }

    public static UnicodeString fromCharSequence(CharSequence chars) {
        int uLength = StringTool.getStringLength(chars);
        if (uLength == chars.length()) {
            return new BMPString(chars.toString());
        }
        byte[] triples = new byte[uLength * 3];
        int j = 0;
        for (int i2 = 0; i2 < chars.length(); ++i2) {
            char c = chars.charAt(i2);
            if (UTF16CharacterSet.isSurrogate(c)) {
                int cp = UTF16CharacterSet.combinePair(c, chars.charAt(++i2));
                triples[j++] = (byte)(cp >> 16 & 0xFF);
                triples[j++] = (byte)(cp >> 8 & 0xFF);
                triples[j++] = (byte)(cp & 0xFF);
                continue;
            }
            triples[j++] = 0;
            triples[j++] = (byte)(c >> 8 & 0xFF);
            triples[j++] = (byte)(c & 0xFF);
        }
        return new Twine24(triples);
    }

    public static UnicodeString fromLatin1(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i2 = 0; i2 < str.length(); ++i2) {
            bytes[i2] = (byte)(str.charAt(i2) & 0xFF);
        }
        return new Twine8(bytes);
    }

    public static IntIterator codePoints(final CharSequence value) {
        return new IntIterator(){
            int i = 0;
            boolean expectingLowSurrogate;

            @Override
            public boolean hasNext() {
                return this.i < value.length();
            }

            @Override
            public int next() {
                char c;
                if (UTF16CharacterSet.isHighSurrogate(c = value.charAt(this.i++))) {
                    try {
                        int d;
                        int n = d = this.hasNext() ? (int)value.charAt(this.i++) : -1;
                        if (!UTF16CharacterSet.isLowSurrogate(d)) {
                            throw new IllegalStateException("Unmatched surrogate code value " + c + " at position " + this.i);
                        }
                        return UTF16CharacterSet.combinePair(c, (char)d);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalStateException("Invalid surrogate at end of string");
                    }
                }
                return c;
            }
        };
    }

    public static String diagnosticDisplay(String s) {
        StringBuilder fsb = new StringBuilder(s.length());
        int len = s.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = s.charAt(i2);
            if (c >= ' ' && c <= '~') {
                fsb.append(c);
                continue;
            }
            fsb.append("\\u");
            for (int shift = 12; shift >= 0; shift -= 4) {
                fsb.append("0123456789ABCDEF".charAt(c >> shift & 0xF));
            }
        }
        return fsb.toString();
    }

    public static void prependWideChar(StringBuilder builder, int ch) {
        if (ch > 65535) {
            char[] pair = new char[]{UTF16CharacterSet.highSurrogate(ch), UTF16CharacterSet.lowSurrogate(ch)};
            builder.insert(0, pair);
        } else {
            builder.insert(0, (char)ch);
        }
    }

    public static void prependRepeated(StringBuilder builder, char ch, int count) {
        char[] array = new char[count];
        Arrays.fill(array, ch);
        builder.insert(0, array);
    }

    public static void appendRepeated(StringBuilder builder, char ch, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            builder.append(ch);
        }
    }

    public static int lastCodePoint(UnicodeString str) {
        return str.codePointAt(str.length() - 1L);
    }

    public static long lastIndexOf(UnicodeString str, int codePoint) {
        for (long i2 = str.length() - 1L; i2 >= 0L; --i2) {
            if (str.codePointAt(i2) != codePoint) continue;
            return i2;
        }
        return -1L;
    }

    public static UnicodeString compress(char[] in, int offset, int len, boolean compressWS) {
        char c;
        int k;
        if (len == 0) {
            return EmptyUnicodeString.getInstance();
        }
        int max = 255;
        int end = offset + len;
        boolean allWhite = compressWS;
        int surrogates = 0;
        if (compressWS) {
            for (k = offset; k < end; ++k) {
                c = in[k];
                if (Whitespace.isWhite(c)) continue;
                allWhite = false;
                break;
            }
            if (allWhite) {
                return CompressedWhitespace.compressWS(in, offset, len);
            }
        }
        while (k < end) {
            c = in[k++];
            max |= c;
            if (!UTF16CharacterSet.isSurrogate(c)) continue;
            ++surrogates;
        }
        if (max < 256) {
            byte[] array = new byte[len];
            int i2 = offset;
            int j = 0;
            while (i2 < end) {
                array[j++] = (byte)in[i2++];
            }
            return new Twine8(array);
        }
        if (surrogates == 0) {
            char[] array = Arrays.copyOfRange(in, offset, offset + len);
            return new Twine16(array);
        }
        byte[] array = new byte[3 * (len - surrogates / 2)];
        int i3 = offset;
        int j = 0;
        while (i3 < end) {
            char c2;
            if (UTF16CharacterSet.isSurrogate(c2 = in[i3++])) {
                int cp = UTF16CharacterSet.combinePair(c2, in[i3++]);
                array[j++] = (byte)((cp & 0xFFFFFF) >> 16);
                array[j++] = (byte)((cp & 0xFFFF) >> 8);
                array[j++] = (byte)(cp & 0xFF);
                continue;
            }
            array[j++] = 0;
            array[j++] = (byte)((c2 & 0xFFFF) >> 8);
            array[j++] = (byte)(c2 & 0xFF);
        }
        return new Twine24(array);
    }

    public static void copy8to16(byte[] source, int sourcePos, char[] dest, int destPos, int count) {
        int last = sourcePos + count;
        int i2 = sourcePos;
        int j = destPos;
        while (i2 < last) {
            dest[j++] = (char)(source[i2++] & 0xFF);
        }
    }

    public static void copy8to24(byte[] source, int sourcePos, byte[] dest, int destPos, int count) {
        int last = sourcePos + count;
        int i2 = sourcePos;
        int j = destPos * 3;
        while (i2 < last) {
            dest[j++] = 0;
            dest[j++] = 0;
            dest[j++] = source[i2++];
        }
    }

    public static void copy16to24(char[] source, int sourcePos, byte[] dest, int destPos, int count) {
        int last = sourcePos + count;
        int i2 = sourcePos;
        int j = destPos * 3;
        while (i2 < last) {
            char c = source[i2++];
            dest[j++] = 0;
            dest[j++] = (byte)(c >> 8 & 0xFF);
            dest[j++] = (byte)(c & 0xFF);
        }
    }
}

