/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.hof.FunctionSequenceCoercer;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyFunctionTypeWithAssertions;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class SpecificFunctionType
extends AnyFunctionType {
    private final SequenceType[] argTypes;
    private final SequenceType resultType;
    private final AnnotationList annotations;
    public static final FunctionItemType COMPONENT_FUNCTION_TYPE = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING}, SequenceType.ANY_SEQUENCE);

    public SpecificFunctionType(SequenceType[] argTypes, SequenceType resultType) {
        this.argTypes = Objects.requireNonNull(argTypes);
        this.resultType = Objects.requireNonNull(resultType);
        this.annotations = AnnotationList.EMPTY;
    }

    public SpecificFunctionType(SequenceType[] argTypes, SequenceType resultType, AnnotationList annotations) {
        this.argTypes = Objects.requireNonNull(argTypes);
        this.resultType = Objects.requireNonNull(resultType);
        this.annotations = Objects.requireNonNull(annotations);
    }

    public int getArity() {
        return this.argTypes.length;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return this.argTypes;
    }

    @Override
    public SequenceType getResultType() {
        return this.resultType;
    }

    @Override
    public AnnotationList getAnnotationAssertions() {
        return this.annotations;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy th) {
        if (this.getArity() != 1) {
            return false;
        }
        ItemType argType = this.getArgumentTypes()[0].getPrimaryType();
        return th.isSubType(BuiltInAtomicType.INTEGER, argType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("(function(");
        for (int i2 = 0; i2 < this.argTypes.length; ++i2) {
            sb.append(this.argTypes[i2].toString());
            if (i2 >= this.argTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") as ");
        sb.append(this.resultType.toString());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toExportString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("(function(");
        for (int i2 = 0; i2 < this.argTypes.length; ++i2) {
            sb.append(this.argTypes[i2].toExportString());
            if (i2 >= this.argTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") as ");
        sb.append(this.resultType.toExportString());
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof SpecificFunctionType) {
            SpecificFunctionType f2 = (SpecificFunctionType)other;
            if (!this.resultType.equals(f2.resultType)) {
                return false;
            }
            if (this.argTypes.length != f2.argTypes.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.argTypes.length; ++i2) {
                if (this.argTypes[i2].equals(f2.argTypes[i2])) continue;
                return false;
            }
            return this.getAnnotationAssertions().equals(f2.getAnnotationAssertions());
        }
        return false;
    }

    public int hashCode() {
        int h = this.resultType.hashCode() ^ this.argTypes.length;
        for (SequenceType argType : this.argTypes) {
            h ^= argType.hashCode();
        }
        return h;
    }

    @Override
    public Affinity relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance() || other instanceof AnyFunctionTypeWithAssertions) {
            return Affinity.SUBSUMED_BY;
        }
        if (this.equals(other)) {
            return Affinity.SAME_TYPE;
        }
        if (other instanceof ArrayItemType || other instanceof MapType) {
            Affinity rrel = other.relationship(this, th);
            switch (rrel) {
                case SUBSUMES: {
                    return Affinity.SUBSUMED_BY;
                }
                case SUBSUMED_BY: {
                    return Affinity.SUBSUMES;
                }
            }
            return rrel;
        }
        if (this.argTypes.length != other.getArgumentTypes().length) {
            return Affinity.DISJOINT;
        }
        boolean wider = false;
        boolean narrower = false;
        block16: for (int i2 = 0; i2 < this.argTypes.length; ++i2) {
            Affinity argRel = th.sequenceTypeRelationship(this.argTypes[i2], other.getArgumentTypes()[i2]);
            switch (argRel) {
                case DISJOINT: {
                    return Affinity.DISJOINT;
                }
                case SUBSUMES: {
                    narrower = true;
                    continue block16;
                }
                case SUBSUMED_BY: {
                    wider = true;
                    continue block16;
                }
                case OVERLAPS: {
                    wider = true;
                    narrower = true;
                    continue block16;
                }
            }
        }
        Affinity resRel = th.sequenceTypeRelationship(this.resultType, other.getResultType());
        switch (resRel) {
            case DISJOINT: {
                return Affinity.DISJOINT;
            }
            case SUBSUMES: {
                wider = true;
                break;
            }
            case SUBSUMED_BY: {
                narrower = true;
                break;
            }
            case OVERLAPS: {
                wider = true;
                narrower = true;
                break;
            }
        }
        if (wider) {
            if (narrower) {
                return Affinity.OVERLAPS;
            }
            return Affinity.SUBSUMES;
        }
        if (narrower) {
            return Affinity.SUBSUMED_BY;
        }
        return Affinity.SAME_TYPE;
    }

    @Override
    public double getDefaultPriority() {
        double prio = 1.0;
        for (SequenceType st : this.getArgumentTypes()) {
            prio *= st.getPrimaryType().getNormalizedDefaultPriority();
        }
        return prio;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        if (!(item instanceof FunctionItem)) {
            return false;
        }
        if (item instanceof MapItem) {
            if (this.getArity() == 1 && this.argTypes[0].getCardinality() == 16384 && this.argTypes[0].getPrimaryType().isPlainType() && Cardinality.allowsZero(this.resultType.getCardinality())) {
                for (KeyValuePair pair : ((MapItem)item).keyValuePairs()) {
                    if (this.resultType.matches(pair.value, th)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (item instanceof ArrayItem) {
            if (this.getArity() == 1 && this.argTypes[0].getCardinality() == 16384 && this.argTypes[0].getPrimaryType().isPlainType()) {
                Affinity rel = th.relationship(this.argTypes[0].getPrimaryType(), BuiltInAtomicType.INTEGER);
                if (rel != Affinity.SAME_TYPE && rel != Affinity.SUBSUMED_BY) {
                    return false;
                }
                for (GroundedValue member : ((ArrayItem)item).members()) {
                    if (this.resultType.matches(member, th)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        Affinity affinity = th.relationship(((FunctionItem)item).getFunctionItemType(), this);
        return affinity == Affinity.SAME_TYPE || affinity == Affinity.SUBSUMED_BY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        Object s;
        if (!(item instanceof FunctionItem)) {
            return Optional.empty();
        }
        if (item instanceof MapItem) {
            if (this.getArity() != 1) {
                String s2 = "The function arity is " + this.getArity() + "; a map can only be supplied for a function type with arity 1";
                return Optional.of(s2);
            }
            if (this.argTypes[0].getCardinality() == 16384 && this.argTypes[0].getPrimaryType().isPlainType()) {
                for (KeyValuePair pair : ((MapItem)item).keyValuePairs()) {
                    if (this.resultType.matches(pair.value, th)) continue;
                    String s3 = "The supplied map contains an entry with key (" + pair.key + ") whose corresponding value (" + Err.depictSequence(pair.value) + ") is not an instance of the return type in the function signature (" + this.resultType + ")";
                    Optional<String> more = this.resultType.explainMismatch(pair.value, th);
                    if (more.isPresent()) {
                        s3 = s3 + ". " + more.get();
                    }
                    return Optional.of(s3);
                }
            } else {
                String s4 = "The function argument is of type " + this.argTypes[0] + "; a map can only be supplied for a function type whose argument type is atomic";
                return Optional.of(s4);
            }
        }
        if (item instanceof ArrayItem) {
            String s5;
            if (this.getArity() != 1) {
                s5 = "The function arity is " + this.getArity() + "; an array can only be supplied for a function type with arity 1";
                return Optional.of(s5);
            }
            if (this.argTypes[0].getCardinality() == 16384 && this.argTypes[0].getPrimaryType().isPlainType()) {
                Affinity rel = th.relationship(this.argTypes[0].getPrimaryType(), BuiltInAtomicType.INTEGER);
                if (rel != Affinity.SAME_TYPE && rel != Affinity.SUBSUMED_BY) {
                    s = "The function expects an argument of type " + this.argTypes[0] + "; an array can only be supplied for a function that expects an integer";
                    return Optional.of(s);
                }
                for (GroundedValue member : ((ArrayItem)item).members()) {
                    if (this.resultType.matches(member, th)) continue;
                    String s6 = "The supplied array contains an entry (" + Err.depictSequence(member) + ") is not an instance of the return type in the function signature (" + this.resultType + ")";
                    Optional<String> more = this.resultType.explainMismatch(member, th);
                    if (more.isPresent()) {
                        s6 = s6 + ". " + more.get();
                    }
                    return Optional.of(s6);
                }
            } else {
                s5 = "The function argument is of type " + this.argTypes[0] + "; an array can only be supplied for a function type whose argument type is xs:integer";
                return Optional.of(s5);
            }
        }
        FunctionItemType other = ((FunctionItem)item).getFunctionItemType();
        if (this.getArity() != ((FunctionItem)item).getArity()) {
            s = "The required function arity is " + this.getArity() + "; the supplied function has arity " + ((FunctionItem)item).getArity();
            return Optional.of(s);
        }
        Affinity affinity = th.sequenceTypeRelationship(this.resultType, other.getResultType());
        if (affinity != Affinity.SAME_TYPE && affinity != Affinity.SUBSUMES) {
            String s7 = "The return type of the required function is " + this.resultType + " but the return type of the supplied function is " + other.getResultType();
            return Optional.of(s7);
        }
        int j = 0;
        while (j < this.getArity()) {
            affinity = th.sequenceTypeRelationship(this.argTypes[j], other.getArgumentTypes()[j]);
            if (affinity != Affinity.SAME_TYPE && affinity != Affinity.SUBSUMED_BY) {
                String s8 = "The type of the " + RoleDiagnostic.ordinal(j + 1) + " argument of the required function is " + this.argTypes[j] + " but the declared type of the corresponding argument of the supplied function is " + other.getArgumentTypes()[j];
                return Optional.of(s8);
            }
            ++j;
        }
        return Optional.empty();
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression exp, Supplier<RoleDiagnostic> role, boolean allow40) {
        return new FunctionSequenceCoercer(exp, this, role, allow40);
    }
}

