/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.Converter;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;

@Converter(generateBulkLoader=true)
public final class CamelConverter {
    private CamelConverter() {
    }

    @Converter(order=1)
    public static Processor toProcessor(Expression expression) {
        return exchange2 -> {
            Object answer = expression.evaluate(exchange2, Object.class);
            Message out = exchange2.getOut();
            out.copyFrom(exchange2.getIn());
            out.setBody(answer);
        };
    }

    @Converter(order=2)
    public static Processor toProcessor(Predicate predicate) {
        return exchange2 -> {
            boolean answer = predicate.matches(exchange2);
            Message out = exchange2.getOut();
            out.copyFrom(exchange2.getIn());
            out.setBody(answer);
        };
    }
}

