/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.BeanConfigInject;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NoSuchBeanTypeException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyInject;
import org.apache.camel.ProxyInstantiationException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.engine.DefaultConsumerTemplate;
import org.apache.camel.impl.engine.DefaultFluentProducerTemplate;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.impl.engine.SubscribeMethodProcessor;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPostProcessorHelper
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelPostProcessorHelper.class);
    private CamelContext camelContext;

    public CamelPostProcessorHelper() {
    }

    public CamelPostProcessorHelper(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void consumerInjection(Method method, Object bean2, String beanName) {
        Consume consume = method.getAnnotation(Consume.class);
        if (consume != null) {
            LOG.debug("Creating a consumer for: {}", (Object)consume);
            this.subscribeMethod(method, bean2, beanName, consume.value(), consume.property(), consume.predicate());
        }
    }

    public void subscribeMethod(Method method, Object bean2, String beanName, String endpointUri, String endpointProperty, String predicate) {
        String injectionPointName = method.getName();
        Endpoint endpoint = this.getEndpointInjection(bean2, endpointUri, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            boolean multipleConsumer = false;
            if (endpoint instanceof MultipleConsumersSupport) {
                MultipleConsumersSupport consumersSupport = (MultipleConsumersSupport)((Object)endpoint);
                multipleConsumer = consumersSupport.isMultipleConsumersSupported();
            }
            try {
                SubscribeMethodProcessor processor = this.getConsumerProcessor(endpoint);
                if (multipleConsumer || processor == null) {
                    processor = new SubscribeMethodProcessor(endpoint);
                    endpoint.getCamelContext().addService(processor, true);
                    processor.addMethod(bean2, method, endpoint, predicate);
                    Consumer consumer = endpoint.createConsumer(processor);
                    this.startService(consumer, endpoint.getCamelContext(), bean2, beanName);
                } else {
                    processor.addMethod(bean2, method, endpoint, predicate);
                }
                if (predicate != null) {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {} with predicate: {}", new Object[]{method, endpoint, predicate});
                } else {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {}", (Object)method, (Object)endpoint);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    protected void startService(Service service, CamelContext camelContext, Object bean2, String beanName) throws Exception {
        if (camelContext != null) {
            camelContext.deferStartService(service, true);
        } else {
            ServiceHelper.startService(service);
        }
        boolean singleton = this.isSingleton(bean2, beanName);
        if (!singleton) {
            LOG.debug("Service is not singleton so you must remember to stop it manually {}", (Object)service);
        }
    }

    protected SubscribeMethodProcessor getConsumerProcessor(Endpoint endpoint) {
        Set<SubscribeMethodProcessor> processors = endpoint.getCamelContext().hasServices(SubscribeMethodProcessor.class);
        return processors.stream().filter(s -> s.getEndpoint() == endpoint).findFirst().orElse(null);
    }

    public Endpoint getEndpointInjection(Object bean2, String uri, String propertyName, String injectionPointName, boolean mandatory) {
        Endpoint answer = org.apache.camel.util.ObjectHelper.isEmpty(uri) ? this.doGetEndpointInjection(bean2, propertyName, injectionPointName) : this.doGetEndpointInjection(uri, injectionPointName, mandatory);
        if (answer instanceof DelegateEndpoint) {
            DelegateEndpoint delegateEndpoint = (DelegateEndpoint)answer;
            answer = delegateEndpoint.getEndpoint();
        }
        return answer;
    }

    private Endpoint doGetEndpointInjection(String uri, String injectionPointName, boolean mandatory) {
        return CamelContextHelper.getEndpointInjection(this.getCamelContext(), uri, injectionPointName, mandatory);
    }

    private Endpoint doGetEndpointInjection(Object bean2, String propertyName, String injectionPointName) {
        if (org.apache.camel.util.ObjectHelper.isEmpty(propertyName)) {
            propertyName = injectionPointName;
        }
        try {
            Object value = PluginHelper.getBeanIntrospection(this.getCamelContext()).getOrElseProperty(bean2, propertyName, null, false);
            if (value == null) {
                value = PluginHelper.getBeanIntrospection(this.getCamelContext()).getOrElseProperty(bean2, propertyName + "Endpoint", null, false);
            }
            if (value == null && propertyName.startsWith("on")) {
                propertyName = propertyName.substring(2);
                return this.doGetEndpointInjection(bean2, propertyName, injectionPointName);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)value;
                return endpoint;
            }
            String uriOrRef = this.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
            return this.getCamelContext().getEndpoint(uriOrRef);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting property " + propertyName + " from bean " + String.valueOf(bean2) + " due " + e.getMessage(), e);
        }
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointProperty, String injectionPointName, Object bean2, String beanName) {
        return this.getInjectionValue(type, endpointUri, endpointProperty, injectionPointName, bean2, beanName, true);
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointProperty, String injectionPointName, Object bean2, String beanName, boolean binding) {
        if (type.isAssignableFrom(ProducerTemplate.class)) {
            return this.createInjectionProducerTemplate(endpointUri, endpointProperty, injectionPointName, bean2);
        }
        if (type.isAssignableFrom(FluentProducerTemplate.class)) {
            return this.createInjectionFluentProducerTemplate(endpointUri, endpointProperty, injectionPointName, bean2);
        }
        if (type.isAssignableFrom(ConsumerTemplate.class)) {
            return this.createInjectionConsumerTemplate(endpointUri, endpointProperty, injectionPointName);
        }
        Endpoint endpoint = this.getEndpointInjection(bean2, endpointUri, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint, bean2, beanName);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint, bean2, beanName);
            }
            if (type.isInterface()) {
                try {
                    BeanProxyFactory factory = PluginHelper.getBeanProxyFactory(endpoint.getCamelContext());
                    return factory.createProxy(endpoint, binding, type);
                }
                catch (Exception e) {
                    throw this.createProxyInstantiationRuntimeException(type, endpoint, e);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject/@Produce for: " + String.valueOf(endpoint));
        }
        return null;
    }

    public Object getInjectionPropertyValue(Class<?> type, Type genericType, String propertyName, String propertyDefaultValue, String separator) {
        try {
            String prefix = "{{";
            String suffix = "}}";
            Object key = !propertyName.contains(prefix) ? prefix + propertyName + suffix : propertyName;
            String value = this.getCamelContext().resolvePropertyPlaceholders((String)key);
            if (value != null) {
                if (separator != null && !separator.isBlank()) {
                    Object values = CamelPostProcessorHelper.convertValueUsingSeparator(this.camelContext, type, genericType, value, separator);
                    return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, values);
                }
                return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, value);
            }
            return null;
        }
        catch (Exception e) {
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(propertyDefaultValue)) {
                try {
                    if (separator != null && !separator.isBlank()) {
                        Object values = CamelPostProcessorHelper.convertValueUsingSeparator(this.camelContext, type, genericType, propertyDefaultValue, separator);
                        return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, values);
                    }
                    return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, propertyDefaultValue);
                }
                catch (Exception e2) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(e2);
                }
            }
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    private static Object convertValueUsingSeparator(CamelContext camelContext, Class<?> type, Type genericType, String value, String separator) throws NoTypeConversionAvailableException {
        if (type.isArray()) {
            return CamelPostProcessorHelper.convertArrayUsingSeparator(camelContext, type, value, separator);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return CamelPostProcessorHelper.convertCollectionUsingSeparator(camelContext, type, genericType, value, separator);
        }
        if (Map.class.isAssignableFrom(type)) {
            return CamelPostProcessorHelper.convertMapUsingSeparator(camelContext, genericType, value, separator);
        }
        return null;
    }

    private static Map<String, Object> convertMapUsingSeparator(CamelContext camelContext, Type genericType, String value, String separator) throws NoTypeConversionAvailableException {
        String[] arr;
        Class ct = Object.class;
        if (genericType != null) {
            Class<?> clazz;
            String name = StringHelper.between(genericType.getTypeName(), "<", ">");
            if ((name = StringHelper.afterLast(name, ",")) != null && (clazz = camelContext.getClassResolver().resolveClass(name.trim())) != null) {
                ct = clazz;
            }
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (String s : arr = value.split(separator)) {
            String v = s.trim();
            if (!v.contains("=")) continue;
            String k = StringHelper.before(v, "=").trim();
            String e = StringHelper.after(v, "=").trim();
            values.put(k, camelContext.getTypeConverter().mandatoryConvertTo(ct, e));
        }
        return values;
    }

    private static Collection<?> convertCollectionUsingSeparator(CamelContext camelContext, Class<?> type, Type genericType, String value, String separator) throws NoTypeConversionAvailableException {
        String[] arr;
        boolean set;
        Class<?> clazz;
        String name;
        Class ct = Object.class;
        if (genericType != null && (name = StringHelper.between(genericType.getTypeName(), "<", ">")) != null && (clazz = camelContext.getClassResolver().resolveClass(name.trim())) != null) {
            ct = clazz;
        }
        AbstractCollection values = (set = type.isAssignableFrom(Set.class)) ? new LinkedHashSet() : new ArrayList();
        for (String s : arr = value.split(separator)) {
            String v = s.trim();
            values.add(camelContext.getTypeConverter().mandatoryConvertTo(ct, v));
        }
        return values;
    }

    private static Object[] convertArrayUsingSeparator(CamelContext camelContext, Class<?> type, String value, String separator) throws NoTypeConversionAvailableException {
        String[] arr = value.split(separator);
        Object[] values = new Object[arr.length];
        Class<?> ct = type.getComponentType();
        for (int i2 = 0; i2 < arr.length; ++i2) {
            String v = arr[i2].trim();
            values[i2] = camelContext.getTypeConverter().mandatoryConvertTo(ct, v);
        }
        return values;
    }

    public Object getInjectionBeanValue(Class<?> type, String name) {
        if (org.apache.camel.util.ObjectHelper.isEmpty(name)) {
            Object found;
            if (this.getCamelContext() != null && type.isAssignableFrom(this.getCamelContext().getClass())) {
                return this.getCamelContext();
            }
            Object v0 = found = this.getCamelContext() != null ? this.getCamelContext().getRegistry().findSingleByType(type) : null;
            if (found == null) {
                if (this.getCamelContext() != null && type.isAssignableFrom(Registry.class)) {
                    return this.getCamelContext().getRegistry();
                }
                if (this.getCamelContext() != null && type.isAssignableFrom(TypeConverter.class)) {
                    return this.getCamelContext().getTypeConverter();
                }
                Service answer = null;
                if (this.getCamelContext() != null && type.isAssignableFrom(FluentProducerTemplate.class)) {
                    answer = this.getCamelContext().createFluentProducerTemplate();
                }
                if (this.getCamelContext() != null && type.isAssignableFrom(ProducerTemplate.class)) {
                    answer = this.getCamelContext().createProducerTemplate();
                }
                if (this.getCamelContext() != null && type.isAssignableFrom(ConsumerTemplate.class)) {
                    answer = this.getCamelContext().createConsumerTemplate();
                }
                if (answer != null) {
                    try {
                        this.getCamelContext().addService(answer);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException(e);
                    }
                    return answer;
                }
                throw new NoSuchBeanTypeException(type);
            }
            return found;
        }
        return CamelContextHelper.mandatoryLookup(this.getCamelContext(), name, type);
    }

    public Object getInjectionBeanConfigValue(Class<?> type, String name) {
        String[] names;
        String rootKey;
        CamelContext ecc = this.getCamelContext();
        boolean mapType = false;
        Map<String, Object> map = null;
        if (type.isAssignableFrom(Map.class)) {
            map = new LinkedHashMap();
            mapType = true;
        } else if (type.isAssignableFrom(Properties.class)) {
            map = new Properties();
            mapType = true;
        }
        Object bean2 = null;
        if (map == null && (bean2 = ecc.getRegistry().findSingleByType(type)) == null) {
            try {
                bean2 = ecc.getInjector().newInstance(type);
            }
            catch (Exception e) {
                return null;
            }
        }
        if ((rootKey = name).endsWith(".")) {
            rootKey = rootKey.substring(0, rootKey.length() - 1);
        }
        String uRootKey = rootKey.toUpperCase(Locale.US);
        Properties props = ecc.getPropertiesComponent().loadProperties();
        if (map == null) {
            map = new LinkedHashMap();
        }
        for (String key : props.stringPropertyNames()) {
            String uKey = key.toUpperCase(Locale.US);
            if (!uKey.startsWith(uRootKey)) continue;
            String sKey = key.substring(rootKey.length());
            if (sKey.startsWith(".")) {
                sKey = sKey.substring(1);
            }
            map.put(sKey, props.getProperty(key));
        }
        if (mapType) {
            return map;
        }
        PropertyConfigurer configurer = null;
        for (String n : names = new String[]{type.getName() + "-configurer", type.getSimpleName() + "-configurer", rootKey + "-configurer"}) {
            configurer = PluginHelper.getConfigurerResolver(ecc).resolvePropertyConfigurer(n, ecc);
            if (configurer != null) break;
        }
        new PropertyBindingSupport.Builder().withCamelContext(ecc).withIgnoreCase(true).withTarget(bean2).withConfigurer(configurer).withProperties(map).bind();
        return bean2;
    }

    public Object getInjectionBeanMethodValue(CamelContext context, Method method, Object bean2, String beanName, String annotationName) {
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            throw new IllegalArgumentException("@" + annotationName + " on class: " + String.valueOf(method.getDeclaringClass()) + " method: " + method.getName() + " with void return type is not allowed");
        }
        Object[] parameters = this.bindToRegistryParameterMapping(context, method);
        Object value = parameters != null ? ObjectHelper.invokeMethod(method, bean2, parameters) : ObjectHelper.invokeMethod(method, bean2, new Object[0]);
        return value;
    }

    private Object[] bindToRegistryParameterMapping(CamelContext context, Method method) {
        if (method.getParameterCount() == 0) {
            return null;
        }
        Object[] parameters = new Object[method.getParameterCount()];
        for (int i2 = 0; i2 < method.getParameterCount(); ++i2) {
            Class<Object> type = method.getParameterTypes()[i2];
            Type genericType = method.getGenericParameterTypes()[i2];
            if (type.isAssignableFrom(CamelContext.class)) {
                parameters[i2] = context;
            } else if (type.isAssignableFrom(Registry.class)) {
                parameters[i2] = context.getRegistry();
            } else if (type.isAssignableFrom(TypeConverter.class)) {
                parameters[i2] = context.getTypeConverter();
            } else {
                Annotation[] anns = method.getParameterAnnotations()[i2];
                if (anns.length == 1) {
                    Annotation ann = anns[0];
                    if (ann.annotationType() == PropertyInject.class) {
                        pi = (PropertyInject)ann;
                        parameters[i2] = result = this.getInjectionPropertyValue(type, genericType, pi.value(), pi.defaultValue(), pi.separator());
                    } else if (ann.annotationType() == BeanConfigInject.class) {
                        pi = (BeanConfigInject)ann;
                        parameters[i2] = result = this.getInjectionBeanConfigValue(type, pi.value());
                    } else if (ann.annotationType() == BeanInject.class) {
                        BeanInject bi = (BeanInject)ann;
                        parameters[i2] = result = this.getInjectionBeanValue(type, bi.value());
                    }
                } else {
                    Set<?> instances = context.getRegistry().findByType(type);
                    if (instances.size() == 1) {
                        parameters[i2] = instances.iterator().next();
                    } else if (instances.size() > 1) {
                        throw new IllegalArgumentException("Multiple beans of the same type: " + String.valueOf(type) + " exists in the Camel registry. Specify the bean name on @BeanInject to bind to a single bean, at the method: " + String.valueOf(method));
                    }
                }
            }
            if (parameters[i2] != null) continue;
            int pos = i2 + 1;
            throw new IllegalArgumentException("@BindToProperty cannot bind parameter #" + pos + " on method: " + String.valueOf(method));
        }
        return parameters;
    }

    protected ProducerTemplate createInjectionProducerTemplate(String endpointUri, String endpointProperty, String injectionPointName, Object bean2) {
        Endpoint endpoint = this.getEndpointInjection(bean2, endpointUri, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultProducerTemplate answer = new DefaultProducerTemplate(context, endpoint);
        try {
            this.startService(answer, context, bean2, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected FluentProducerTemplate createInjectionFluentProducerTemplate(String endpointUri, String endpointProperty, String injectionPointName, Object bean2) {
        Endpoint endpoint = this.getEndpointInjection(bean2, endpointUri, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultFluentProducerTemplate answer = new DefaultFluentProducerTemplate(context);
        answer.setDefaultEndpoint(endpoint);
        try {
            this.startService(answer, context, bean2, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected ConsumerTemplate createInjectionConsumerTemplate(String endpointUri, String endpointProperty, String injectionPointName) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this.getCamelContext());
        try {
            this.startService(answer, null, null, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint, Object bean2, String beanName) {
        try {
            PollingConsumer consumer = endpoint.createPollingConsumer();
            this.startService(consumer, endpoint.getCamelContext(), bean2, beanName);
            return consumer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint, Object bean2, String beanName) {
        try {
            return PluginHelper.getDeferServiceFactory(endpoint.getCamelContext()).createProducer(endpoint);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
        return new ProxyInstantiationException(type, endpoint, e);
    }

    protected boolean isSingleton(Object bean2, String beanName) {
        if (bean2 instanceof IsSingleton) {
            IsSingleton singleton = (IsSingleton)bean2;
            return singleton.isSingleton();
        }
        return true;
    }

    public static String initMethodCandidate(Object bean2) {
        if (bean2 instanceof Service) {
            return "start";
        }
        return null;
    }

    public static String destroyMethodCandidate(Object bean2) {
        if (bean2 instanceof Service) {
            return "stop";
        }
        if (bean2 instanceof Closeable) {
            return "close";
        }
        return null;
    }
}

