/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.spi.Language;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.builder.PredicateBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public final class SubscribeMethodProcessor
extends AsyncProcessorSupport
implements Navigate<Processor> {
    private final Endpoint endpoint;
    private final Map<AsyncProcessor, Predicate> methods = new LinkedHashMap<AsyncProcessor, Predicate>();
    private Language simple;

    public SubscribeMethodProcessor(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void addMethod(Object pojo, Method method, Endpoint endpoint, String predicate) throws Exception {
        Processor answer = PluginHelper.getBeanProcessorFactory(endpoint.getCamelContext()).createBeanProcessor(endpoint.getCamelContext(), pojo, method);
        answer = PluginHelper.getInternalProcessorFactory(endpoint.getCamelContext()).addUnitOfWorkProcessorAdvice(endpoint.getCamelContext(), answer, null);
        Predicate p = ObjectHelper.isEmpty(predicate) ? PredicateBuilder.constant(true) : this.simple.createPredicate(predicate);
        this.methods.put((AsyncProcessor)answer, p);
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            for (Map.Entry<AsyncProcessor, Predicate> entry : this.methods.entrySet()) {
                Predicate predicate = entry.getValue();
                if (!predicate.matches(exchange2)) continue;
                return entry.getKey().process(exchange2, callback);
            }
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    protected void doInit() throws Exception {
        this.simple = this.getEndpoint().getCamelContext().resolveLanguage("simple");
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.methods.keySet());
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.methods.keySet());
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.methods.keySet());
    }

    public String toString() {
        return "SubscribeMethodProcessor[" + String.valueOf(this.endpoint) + "]";
    }

    @Override
    public List<Processor> next() {
        return new ArrayList<Processor>(this.methods.keySet());
    }

    @Override
    public boolean hasNext() {
        return !this.methods.isEmpty();
    }
}

