/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;

public final class PredicateToExpressionAdapter
implements Expression {
    private final Predicate predicate;

    public PredicateToExpressionAdapter(Predicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public <T> T evaluate(Exchange exchange2, Class<T> type) {
        boolean matches = this.predicate.matches(exchange2);
        return exchange2.getContext().getTypeConverter().convertTo(type, exchange2, matches);
    }

    public String toString() {
        return this.predicate.toString();
    }

    public static Expression toExpression(Predicate predicate) {
        if (predicate instanceof Expression) {
            Expression expression = (Expression)((Object)predicate);
            return expression;
        }
        return new PredicateToExpressionAdapter(predicate);
    }
}

