/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelLogProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelLogProcessor.class);
    private String id;
    private String routeId;
    private final CamelLogger logger;
    private ExchangeFormatter formatter;
    private MaskingFormatter maskingFormatter;
    private final Set<LogListener> listeners;

    public CamelLogProcessor() {
        this(new CamelLogger(CamelLogProcessor.class.getName()));
    }

    public CamelLogProcessor(CamelLogger logger) {
        this.formatter = new ToStringExchangeFormatter();
        this.logger = logger;
        this.listeners = null;
    }

    public CamelLogProcessor(CamelLogger logger, ExchangeFormatter formatter, MaskingFormatter maskingFormatter, Set<LogListener> listeners) {
        this.logger = logger;
        this.formatter = formatter;
        this.maskingFormatter = maskingFormatter;
        this.listeners = listeners;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        if (this.logger.shouldLog()) {
            String output = this.formatter.format(exchange2);
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange2, output);
            this.logger.log(output);
        }
        callback.done(true);
        return true;
    }

    public void process(Exchange exchange2, Throwable exception) {
        if (this.logger.shouldLog()) {
            String output = this.formatter.format(exchange2);
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format(output);
            }
            output = this.fireListeners(exchange2, output);
            this.logger.log(output, exception);
        }
    }

    public void process(Exchange exchange2, String message) {
        if (this.logger.shouldLog()) {
            Object output = this.formatter.format(exchange2) + message;
            if (this.maskingFormatter != null) {
                output = this.maskingFormatter.format((String)output);
            }
            output = this.fireListeners(exchange2, (String)output);
            this.logger.log((String)output);
        }
    }

    private String fireListeners(Exchange exchange2, String message) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return message;
        }
        for (LogListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                String output = listener.onLog(exchange2, this.logger, message);
                message = output != null ? output : message;
            }
            catch (Exception t) {
                LOG.warn("Ignoring an exception thrown by {}: {}", (Object)listener.getClass().getName(), (Object)t.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("", (Throwable)t);
            }
        }
        return message;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    public void setLogName(String logName) {
        this.logger.setLogName(logName);
    }

    public void setLevel(LoggingLevel level) {
        this.logger.setLevel(level);
    }

    public void setMarker(String marker) {
        this.logger.setMarker(marker);
    }

    public void setMaskingFormatter(MaskingFormatter maskingFormatter) {
        this.maskingFormatter = maskingFormatter;
    }

    static class ToStringExchangeFormatter
    implements ExchangeFormatter {
        ToStringExchangeFormatter() {
        }

        @Override
        public String format(Exchange exchange2) {
            return exchange2.toString();
        }
    }
}

