/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.pox.dom;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.util.Assert;
import org.springframework.ws.pox.PoxMessage;
import org.springframework.ws.pox.dom.DomPoxMessageException;
import org.springframework.ws.transport.TransportOutputStream;
import org.springframework.xml.namespace.QNameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomPoxMessage
implements PoxMessage {
    private final String contentType;
    private final Document document;
    private final Transformer transformer;

    public DomPoxMessage(Document document, Transformer transformer, String contentType) {
        Assert.notNull((Object)document, "'document' must not be null");
        Assert.notNull((Object)transformer, "'transformer' must not be null");
        Assert.hasLength(contentType, "'contentType' must not be empty");
        this.document = document;
        this.transformer = transformer;
        this.contentType = contentType;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public Result getPayloadResult() {
        NodeList children = this.document.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            this.document.removeChild(children.item(i2));
        }
        return new DOMResult(this.document);
    }

    @Override
    public Source getPayloadSource() {
        return new DOMSource(this.document);
    }

    public boolean hasFault() {
        return false;
    }

    public String getFaultReason() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DomPoxMessage ");
        Element root = this.document.getDocumentElement();
        if (root != null) {
            builder.append(' ');
            builder.append(QNameUtils.getQNameForNode(root));
        }
        return builder.toString();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            if (outputStream instanceof TransportOutputStream) {
                TransportOutputStream transportOutputStream = (TransportOutputStream)outputStream;
                transportOutputStream.addHeader("Content-Type", this.contentType);
            }
            this.transformer.transform(this.getPayloadSource(), new StreamResult(outputStream));
        }
        catch (TransformerException ex) {
            throw new DomPoxMessageException("Could write document: " + ex.getMessage(), ex);
        }
    }
}

