/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.mapping.AbstractMapBasedEndpointMapping;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;

public class UriEndpointMapping
extends AbstractMapBasedEndpointMapping {
    private boolean usePath = false;

    public void setUsePath(boolean usePath) {
        this.usePath = usePath;
    }

    @Override
    protected boolean validateLookupKey(String key) {
        try {
            new URI(key);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    protected String getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        WebServiceConnection connection;
        TransportContext transportContext = TransportContextHolder.getTransportContext();
        if (transportContext != null && (connection = transportContext.getConnection()) != null) {
            URI connectionUri = connection.getUri();
            if (this.usePath) {
                return connectionUri.getPath();
            }
            return connectionUri.toString();
        }
        return null;
    }
}

