/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.core;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;
import org.w3c.dom.Node;

public final class EndpointReference
implements Serializable {
    private static final long serialVersionUID = 8999416009328865260L;
    private final URI address;
    private final List<Node> referenceProperties;
    private final List<Node> referenceParameters;

    public EndpointReference(URI address) {
        Assert.notNull((Object)address, "address must not be null");
        this.address = address;
        this.referenceParameters = Collections.emptyList();
        this.referenceProperties = Collections.emptyList();
    }

    public EndpointReference(URI address, List<Node> referenceProperties, List<Node> referenceParameters) {
        Assert.notNull((Object)address, "address must not be null");
        Assert.notNull(referenceProperties, "referenceProperties must not be null");
        Assert.notNull(referenceParameters, "referenceParameters must not be null");
        this.address = address;
        this.referenceProperties = referenceProperties;
        this.referenceParameters = referenceParameters;
    }

    public URI getAddress() {
        return this.address;
    }

    public List<Node> getReferenceProperties() {
        return this.referenceProperties;
    }

    public List<Node> getReferenceParameters() {
        return this.referenceParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EndpointReference) {
            EndpointReference other = (EndpointReference)o;
            return this.address.equals(other.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        return this.address.toString();
    }
}

