/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj.support;

import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.saaj.support.SaajUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SaajContentHandler
implements ContentHandler {
    private SOAPElement element;
    private final SOAPEnvelope envelope;
    private Map<String, String> namespaces = new LinkedHashMap<String, String>();

    public SaajContentHandler(SOAPElement element) {
        Assert.notNull((Object)element, "element must not be null");
        this.envelope = element instanceof SOAPEnvelope ? (SOAPEnvelope)element : SaajUtils.getEnvelope(element);
        this.element = element;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String text = new String(ch, start, length);
            this.element.addTextNode(text);
        }
        catch (SOAPException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            String childPrefix = this.getPrefix(qName);
            SOAPElement child = this.element.addChildElement(localName, childPrefix, uri);
            for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                if (!StringUtils.hasLength(atts.getLocalName(i2))) continue;
                String attributePrefix = this.getPrefix(atts.getQName(i2));
                if ("xmlns".equals(atts.getLocalName(i2)) || "xmlns".equals(attributePrefix)) continue;
                Name attributeName = this.envelope.createName(atts.getLocalName(i2), attributePrefix, atts.getURI(i2));
                child.addAttribute(attributeName, atts.getValue(i2));
            }
            for (String namespacePrefix : this.namespaces.keySet()) {
                String namespaceUri;
                if (this.findParentNamespaceDeclaration(child, namespacePrefix, namespaceUri = this.namespaces.get(namespacePrefix))) continue;
                child.addNamespaceDeclaration(namespacePrefix, namespaceUri);
            }
            this.element = child;
        }
        catch (SOAPException ex) {
            throw new SAXException(ex);
        }
    }

    private boolean findParentNamespaceDeclaration(SOAPElement element, String prefix, String namespaceUri) {
        String result = element.getNamespaceURI(prefix);
        if (namespaceUri.equals(result)) {
            return true;
        }
        try {
            SOAPElement parent = element.getParentElement();
            if (parent != null) {
                return this.findParentNamespaceDeclaration(parent, prefix, namespaceUri);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Assert.isTrue(localName.equals(this.element.getElementName().getLocalName()), "Invalid element on stack");
        Assert.isTrue(uri.equals(this.element.getElementName().getURI()), "Invalid element on stack");
        this.element = this.element.getParentElement();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private String getPrefix(String qName) {
        int idx = qName.indexOf(58);
        if (idx != -1) {
            return qName.substring(0, idx);
        }
        return null;
    }
}

