/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11;

import java.io.IOException;
import javax.xml.transform.Source;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.wsdl.WsdlDefinitionException;
import org.springframework.ws.wsdl.wsdl11.Wsdl11Definition;
import org.springframework.xml.transform.ResourceSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleWsdl11Definition
implements Wsdl11Definition,
InitializingBean {
    private Resource wsdlResource;

    public SimpleWsdl11Definition() {
    }

    public SimpleWsdl11Definition(Resource wsdlResource) {
        Assert.notNull((Object)wsdlResource, "wsdlResource must not be null");
        this.wsdlResource = wsdlResource;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.wsdlResource, "wsdl is required");
        Assert.isTrue(this.wsdlResource.exists(), "wsdl '" + this.wsdlResource + "' does not exist");
    }

    @Override
    public Source getSource() {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            return new ResourceSource(xmlReader, this.wsdlResource);
        }
        catch (SAXException ex) {
            throw new WsdlDefinitionException("Could not create XMLReader", ex);
        }
        catch (IOException ex) {
            throw new WsdlDefinitionException("Could not create source from " + this.wsdlResource, ex);
        }
    }

    public void setWsdl(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    public String toString() {
        return "SimpleWsdl11Definition " + this.wsdlResource;
    }
}

