/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.validation;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.xml.transform.ResourceSource;
import org.springframework.xml.validation.SchemaFactoryUtils;
import org.springframework.xml.validation.XMLReaderFactoryUtils;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class SchemaLoaderUtils {
    public static Schema loadSchema(Resource resource, String schemaLanguage) throws IOException, SAXException {
        return SchemaLoaderUtils.loadSchema(new Resource[]{resource}, schemaLanguage);
    }

    public static Schema loadSchema(Resource[] resources, String schemaLanguage) throws IOException, SAXException {
        Assert.notEmpty((Object[])resources, "No resources given");
        Assert.hasLength(schemaLanguage, "No schema language provided");
        Source[] schemaSources = new Source[resources.length];
        XMLReader xmlReader = XMLReaderFactoryUtils.createXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        for (int i2 = 0; i2 < resources.length; ++i2) {
            Assert.notNull((Object)resources[i2], "Resource is null");
            Assert.isTrue(resources[i2].exists(), "Resource " + resources[i2] + " does not exist");
            schemaSources[i2] = new ResourceSource(xmlReader, resources[i2]);
        }
        SchemaFactory schemaFactory = SchemaFactoryUtils.newInstance(schemaLanguage);
        return schemaFactory.newSchema(schemaSources);
    }

    public static String getSystemId(Resource resource) {
        try {
            return resource.getURL().toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

