/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.util.CompositeIterator;

public class DefaultSqlPrepareStatementStrategy
implements SqlPrepareStatementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSqlPrepareStatementStrategy.class);
    private static final Pattern REPLACE_IN_PATTERN = Pattern.compile("\\:\\?in\\:(\\w+|\\$\\{[^\\}]+\\}|\\$simple\\{[^\\}]+\\})", 8);
    private static final Pattern REPLACE_PATTERN = Pattern.compile("\\:\\?\\w+|\\:\\?\\$\\{[^\\}]+\\}|\\:\\?\\$simple\\{[^\\}]+\\}", 8);
    private static final Pattern NAME_PATTERN = Pattern.compile("\\:\\?((in\\:(\\w+|\\$\\{[^\\}]+\\}|\\$simple\\{[^\\}]+\\}))|(\\w+|\\$\\{[^\\}]+\\}|\\$simple\\{[^\\}]+\\}))", 8);
    private final char separator;

    public DefaultSqlPrepareStatementStrategy() {
        this(',');
    }

    public DefaultSqlPrepareStatementStrategy(char separator) {
        this.separator = separator;
    }

    @Override
    public String prepareQuery(String query2, boolean allowNamedParameters, Exchange exchange) throws SQLException {
        String answer;
        if (allowNamedParameters && this.hasNamedParameters(query2)) {
            if (exchange != null) {
                Matcher matcher = REPLACE_IN_PATTERN.matcher(query2);
                while (matcher.find()) {
                    String found = matcher.group(1);
                    Object parameter = DefaultSqlPrepareStatementStrategy.lookupParameter(found, exchange, null);
                    if (parameter == null) continue;
                    CompositeIterator<?> it = DefaultSqlPrepareStatementStrategy.createInParameterIterator(parameter);
                    StringJoiner replaceBuilder = new StringJoiner(",");
                    while (it.hasNext()) {
                        it.next();
                        replaceBuilder.add("\\?");
                    }
                    String replace = replaceBuilder.toString();
                    String foundEscaped = found.replace("$", "\\$").replace("{", "\\{").replace("}", "\\}");
                    Matcher paramMatcher = Pattern.compile("\\:\\?in\\:" + foundEscaped, 8).matcher(query2);
                    query2 = paramMatcher.replaceAll(replace);
                }
            }
            answer = this.replaceParams(query2);
        } else {
            answer = query2;
        }
        LOG.trace("Prepared query: {}", (Object)answer);
        return answer;
    }

    private String replaceParams(String query2) {
        query2 = this.replaceBracketedParams(query2);
        return REPLACE_PATTERN.matcher(query2).replaceAll("\\?");
    }

    private String replaceBracketedParams(String query2) {
        while (((String)query2).contains(":?${")) {
            int i = ((String)query2).indexOf(":?${");
            int j = DefaultSqlPrepareStatementStrategy.findClosingBracket((String)query2, i + 3);
            if (j == -1) {
                throw new IllegalArgumentException("String doesn't have equal opening and closing brackets: " + (String)query2);
            }
            query2 = ((String)query2).substring(0, i) + "?" + ((String)query2).substring(j + 1);
        }
        return query2;
    }

    private static int findClosingBracket(String text, int openPosition) {
        if (text.charAt(openPosition) != '{') {
            throw new IllegalArgumentException("Character at specified position is not an open bracket");
        }
        int remainingClosingBrackets = 0;
        for (int i = openPosition; i < text.length(); ++i) {
            if (text.charAt(i) == '{') {
                ++remainingClosingBrackets;
            } else if (text.charAt(i) == '}') {
                --remainingClosingBrackets;
            }
            if (remainingClosingBrackets != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<?> createPopulateIterator(String query2, String preparedQuery, int expectedParams, Exchange exchange, Object value) throws SQLException {
        if (this.hasNamedParameters(query2)) {
            return new PopulateIterator(query2, exchange, value);
        }
        if (expectedParams == 1 && value instanceof String) {
            return Collections.singletonList(value).iterator();
        }
        if (value instanceof String) {
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)value, this.separator, true);
            List<String> list = Arrays.asList(tokens);
            return list.iterator();
        }
        return exchange.getContext().getTypeConverter().convertTo(Iterator.class, value);
    }

    @Override
    public void populateStatement(PreparedStatement ps, Iterator<?> iterator, int expectedParams) throws SQLException {
        if (expectedParams <= 0) {
            return;
        }
        Object[] args = new Object[expectedParams];
        int i = 0;
        int argNumber = 1;
        while (iterator != null && iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof CompositeIterator) {
                CompositeIterator it = (CompositeIterator)value;
                while (it.hasNext()) {
                    Object val = it.next();
                    LOG.trace("Setting parameter #{} with value: {}", (Object)argNumber, val);
                    if (argNumber <= expectedParams) {
                        args[i] = val;
                    }
                    ++argNumber;
                    ++i;
                }
                continue;
            }
            LOG.trace("Setting parameter #{} with value: {}", (Object)argNumber, value);
            if (argNumber <= expectedParams) {
                args[i] = value;
            }
            ++argNumber;
            ++i;
        }
        if (argNumber - 1 != expectedParams) {
            throw new SQLException("Number of parameters mismatch. Expected: " + expectedParams + ", was: " + (argNumber - 1));
        }
        ArgumentPreparedStatementSetter setter = new ArgumentPreparedStatementSetter(args);
        setter.setValues(ps);
    }

    protected boolean hasNamedParameters(String query2) {
        NamedQueryParser parser = new NamedQueryParser(query2);
        return parser.next() != null;
    }

    protected static Object lookupParameter(String nextParam, Exchange exchange, Object batchBody) {
        Object body = batchBody != null ? batchBody : exchange.getMessage().getBody();
        Map<?, ?> bodyMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getContext().getTypeConverter().tryConvertTo(Map.class, body));
        Map<?, ?> headersMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getIn().getHeaders());
        Map<?, ?> variablesMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getVariables());
        Object answer = null;
        if ((nextParam.startsWith("$simple{") || nextParam.startsWith("${")) && nextParam.endsWith("}")) {
            if (batchBody != null) {
                exchange = ExchangeHelper.createCopy(exchange, true);
                exchange.getMessage().setBody(batchBody);
            }
            Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(nextParam);
            answer = exp.evaluate(exchange, Object.class);
        } else if (bodyMap.containsKey(nextParam)) {
            answer = bodyMap.get(nextParam);
        } else if (headersMap.containsKey(nextParam)) {
            answer = headersMap.get(nextParam);
        } else if (variablesMap.containsKey(nextParam)) {
            answer = variablesMap.get(nextParam);
        }
        return answer;
    }

    protected static boolean hasParameter(String nextParam, Exchange exchange, Object body) {
        Map<?, ?> bodyMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getContext().getTypeConverter().tryConvertTo(Map.class, body));
        Map<?, ?> headersMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getIn().getHeaders());
        Map<?, ?> variablesMap = DefaultSqlPrepareStatementStrategy.safeMap(exchange.getVariables());
        if ((nextParam.startsWith("$simple{") || nextParam.startsWith("${")) && nextParam.endsWith("}")) {
            return true;
        }
        if (bodyMap.containsKey(nextParam)) {
            return true;
        }
        if (headersMap.containsKey(nextParam)) {
            return true;
        }
        return variablesMap.containsKey(nextParam);
    }

    private static Map<?, ?> safeMap(Map<?, ?> map) {
        return map == null || map.isEmpty() ? Collections.emptyMap() : map;
    }

    protected static CompositeIterator<?> createInParameterIterator(Object value) {
        Iterator<Object> it;
        if (value instanceof String) {
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)value, ',', true);
            List<String> list = Arrays.asList(tokens);
            it = list.iterator();
        } else {
            it = ObjectHelper.createIterator(value, null);
        }
        CompositeIterator ci = new CompositeIterator();
        ci.add(it);
        return ci;
    }

    private static final class PopulateIterator
    implements Iterator<Object> {
        private static final String MISSING_PARAMETER_EXCEPTION = "Cannot find key [%s] in message body or headers to use when setting named parameter in query [%s]";
        private final String query;
        private final NamedQueryParser parser;
        private final Exchange exchange;
        private final Object body;
        private String nextParam;

        private PopulateIterator(String query2, Exchange exchange, Object body) {
            this.query = query2;
            this.exchange = exchange;
            this.body = body;
            this.parser = new NamedQueryParser(query2);
            this.nextParam = this.parser.next();
        }

        @Override
        public boolean hasNext() {
            return this.nextParam != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() {
            CompositeIterator<?> next;
            block7: {
                if (this.nextParam == null) {
                    throw new NoSuchElementException();
                }
                boolean in = false;
                if (this.nextParam.startsWith("in:")) {
                    in = true;
                    this.nextParam = this.nextParam.substring(3);
                }
                next = null;
                try {
                    boolean hasNext = DefaultSqlPrepareStatementStrategy.hasParameter(this.nextParam, this.exchange, this.body);
                    if (hasNext) {
                        next = DefaultSqlPrepareStatementStrategy.lookupParameter(this.nextParam, this.exchange, this.body);
                        if (in && next != null) {
                            next = DefaultSqlPrepareStatementStrategy.createInParameterIterator(next);
                        }
                        break block7;
                    }
                    throw new RuntimeExchangeException(String.format(MISSING_PARAMETER_EXCEPTION, this.nextParam, this.query), this.exchange);
                }
                finally {
                    this.nextParam = this.parser.next();
                }
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class NamedQueryParser {
        private final String query;
        private final Matcher matcher;

        private NamedQueryParser(String query2) {
            this.query = query2;
            this.matcher = NAME_PATTERN.matcher(query2);
        }

        public String next() {
            if (this.matcher.find()) {
                Object param = this.matcher.group(1);
                int openingBrackets = 0;
                int closingBrackets = 0;
                for (int i = 0; i < ((String)param).length(); ++i) {
                    if (((String)param).charAt(i) == '{') {
                        ++openingBrackets;
                    }
                    if (((String)param).charAt(i) != '}') continue;
                    ++closingBrackets;
                }
                if (openingBrackets != closingBrackets) {
                    String querySubstring = this.query.substring(this.matcher.start());
                    int i = querySubstring.indexOf(123);
                    int j = DefaultSqlPrepareStatementStrategy.findClosingBracket(querySubstring, i);
                    param = "$" + querySubstring.substring(i, j + 1);
                }
                return param;
            }
            return null;
        }
    }
}

