/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.RowMapperFactory;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;
import org.springframework.jdbc.core.JdbcTemplate;

@Component(value="sql")
public class SqlComponent
extends HealthCheckComponent {
    @Metadata(autowired=true)
    private DataSource dataSource;
    @Metadata(label="advanced", defaultValue="true")
    private boolean usePlaceholder = true;
    @Metadata(label="advanced", autowired=true)
    private RowMapperFactory rowMapperFactory;
    @Metadata(label="advanced", description="Whether to detect the network address location of the JMS broker on startup. This information is gathered via reflection on the ConnectionFactory, and is vendor specific. This option can be used to turn this off.", defaultValue="true")
    private boolean serviceLocationEnabled = true;

    public SqlComponent() {
    }

    public SqlComponent(Class<? extends Endpoint> endpointClass) {
    }

    public SqlComponent(CamelContext context) {
        super(context);
    }

    public SqlComponent(CamelContext context, Class<? extends Endpoint> endpointClass) {
        super(context);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RowMapperFactory factory;
        String onConsumeBatchComplete;
        String onConsumeFailed;
        String onConsume;
        String parameterPlaceholderSubstitute = this.getAndRemoveParameter(parameters, "placeholder", String.class, "#");
        String query2 = remaining;
        if (this.usePlaceholder) {
            query2 = query2.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsume = this.getAndRemoveParameter(parameters, "consumer.onConsume", String.class)) == null) {
            onConsume = this.getAndRemoveParameter(parameters, "onConsume", String.class);
        }
        if (onConsume != null && this.usePlaceholder) {
            onConsume = onConsume.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeFailed = this.getAndRemoveParameter(parameters, "consumer.onConsumeFailed", String.class)) == null) {
            onConsumeFailed = this.getAndRemoveParameter(parameters, "onConsumeFailed", String.class);
        }
        if (onConsumeFailed != null && this.usePlaceholder) {
            onConsumeFailed = onConsumeFailed.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeBatchComplete = this.getAndRemoveParameter(parameters, "consumer.onConsumeBatchComplete", String.class)) == null) {
            onConsumeBatchComplete = this.getAndRemoveParameter(parameters, "onConsumeBatchComplete", String.class);
        }
        if (onConsumeBatchComplete != null && this.usePlaceholder) {
            onConsumeBatchComplete = onConsumeBatchComplete.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((factory = this.getAndRemoveParameter(parameters, "rowMapperFactory", RowMapperFactory.class)) == null) {
            factory = this.rowMapperFactory;
        }
        SqlEndpoint endpoint = new SqlEndpoint(uri, this);
        endpoint.setServiceLocationEnabled(this.serviceLocationEnabled);
        endpoint.setQuery(query2);
        endpoint.setPlaceholder(parameterPlaceholderSubstitute);
        endpoint.setUsePlaceholder(this.isUsePlaceholder());
        endpoint.setOnConsume(onConsume);
        endpoint.setOnConsumeFailed(onConsumeFailed);
        endpoint.setOnConsumeBatchComplete(onConsumeBatchComplete);
        endpoint.setRowMapperFactory(factory);
        this.setProperties(endpoint, parameters);
        DataSource ds = this.dataSource;
        if (endpoint.getDataSource() != null) {
            ds = endpoint.getDataSource();
        }
        if (ds == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(ds);
        Map<String, Object> templateOptions = PropertiesHelper.extractProperties(parameters, "template.");
        PropertyBindingSupport.bindProperties(this.getCamelContext(), jdbcTemplate, templateOptions);
        endpoint.setJdbcTemplate(jdbcTemplate);
        endpoint.setDataSource(ds);
        endpoint.setTemplateOptions(templateOptions);
        return endpoint;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setUsePlaceholder(boolean usePlaceholder) {
        this.usePlaceholder = usePlaceholder;
    }

    public boolean isUsePlaceholder() {
        return this.usePlaceholder;
    }

    public RowMapperFactory getRowMapperFactory() {
        return this.rowMapperFactory;
    }

    public void setRowMapperFactory(RowMapperFactory rowMapperFactory) {
        this.rowMapperFactory = rowMapperFactory;
    }

    public boolean isServiceLocationEnabled() {
        return this.serviceLocationEnabled;
    }

    public void setServiceLocationEnabled(boolean serviceLocationEnabled) {
        this.serviceLocationEnabled = serviceLocationEnabled;
    }
}

