/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.sql.SQLException;
import java.util.Map;
import org.apache.camel.component.sql.stored.BatchCallableStatementCreatorFactory;
import org.apache.camel.component.sql.stored.CallableStatementWrapper;
import org.apache.camel.component.sql.stored.StatementWrapper;
import org.apache.camel.component.sql.stored.TemplateStoredProcedure;
import org.apache.camel.component.sql.stored.template.TemplateParser;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceSupport;
import org.springframework.jdbc.core.JdbcTemplate;

public class CallableStatementWrapperFactory
extends ServiceSupport {
    public static final int TEMPLATE_CACHE_DEFAULT_SIZE = 200;
    public static final int BATCH_TEMPLATE_CACHE_DEFAULT_SIZE = 200;
    final JdbcTemplate jdbcTemplate;
    final TemplateParser templateParser;
    boolean function;
    private final Map<String, TemplateStoredProcedure> templateCache = LRUCacheFactory.newLRUCache(200);
    private final Map<String, BatchCallableStatementCreatorFactory> batchTemplateCache = LRUCacheFactory.newLRUCache(200);

    public CallableStatementWrapperFactory(JdbcTemplate jdbcTemplate, TemplateParser templateParser, boolean function) {
        this.jdbcTemplate = jdbcTemplate;
        this.templateParser = templateParser;
        this.function = function;
    }

    public StatementWrapper create(String sql) throws SQLException {
        return new CallableStatementWrapper(sql, this);
    }

    public BatchCallableStatementCreatorFactory getTemplateForBatch(String sql) {
        BatchCallableStatementCreatorFactory template = this.batchTemplateCache.get(sql);
        if (template != null) {
            return template;
        }
        template = new BatchCallableStatementCreatorFactory(this.templateParser.parseTemplate(sql));
        this.batchTemplateCache.put(sql, template);
        return template;
    }

    public TemplateStoredProcedure getTemplateStoredProcedure(String sql) {
        TemplateStoredProcedure templateStoredProcedure = this.templateCache.get(sql);
        if (templateStoredProcedure != null) {
            return templateStoredProcedure;
        }
        templateStoredProcedure = new TemplateStoredProcedure(this.jdbcTemplate, this.templateParser.parseTemplate(sql), this.function);
        this.templateCache.put(sql, templateStoredProcedure);
        return templateStoredProcedure;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        try {
            this.templateCache.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.batchTemplateCache.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

