/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.sql.SQLException;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.SqlHelper;
import org.apache.camel.component.sql.stored.SqlStoredEndpoint;
import org.apache.camel.component.sql.stored.StatementWrapper;
import org.apache.camel.component.sql.stored.WrapperExecuteCallback;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ResourceHelper;
import org.springframework.dao.DataAccessException;

public class SqlStoredProducer
extends DefaultProducer {
    private String resolvedTemplate;

    public SqlStoredProducer(SqlStoredEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public SqlStoredEndpoint getEndpoint() {
        return (SqlStoredEndpoint)super.getEndpoint();
    }

    @Override
    public void process(final Exchange exchange) throws Exception {
        StatementWrapper statementWrapper = this.createStatement(exchange);
        statementWrapper.call(new WrapperExecuteCallback(){

            @Override
            public void execute(StatementWrapper ps) throws SQLException, DataAccessException {
                if (SqlStoredProducer.this.getEndpoint().isBatch()) {
                    Iterator iterator = SqlStoredProducer.this.getEndpoint().isUseMessageBodyForTemplate() ? exchange.getIn().getHeader("CamelSqlStoredParameters", Iterator.class) : exchange.getIn().getBody(Iterator.class);
                    if (iterator == null) {
                        throw new IllegalStateException("batch=true but Iterator cannot be found from body or header");
                    }
                    while (iterator.hasNext()) {
                        Object value = iterator.next();
                        ps.addBatch(value, exchange);
                    }
                } else {
                    Object value = SqlStoredProducer.this.getEndpoint().isUseMessageBodyForTemplate() ? exchange.getIn().getHeader("CamelSqlStoredParameters") : exchange.getIn().getBody();
                    ps.populateStatement(value, exchange);
                }
                if (SqlStoredProducer.this.getEndpoint().isBatch()) {
                    int[] updateCounts = ps.executeBatch();
                    int total = 0;
                    for (int count : updateCounts) {
                        total += count;
                    }
                    exchange.getIn().setHeader("CamelSqlStoredUpdateCount", total);
                } else {
                    Object result = ps.executeStatement();
                    exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                    if (result != null) {
                        if (SqlStoredProducer.this.getEndpoint().isNoop()) {
                            exchange.getOut().setBody(exchange.getIn().getBody());
                        } else if (SqlStoredProducer.this.getEndpoint().getOutputHeader() != null) {
                            exchange.getOut().setBody(exchange.getIn().getBody());
                            exchange.getOut().setHeader(SqlStoredProducer.this.getEndpoint().getOutputHeader(), result);
                        } else {
                            exchange.getOut().setBody(result);
                        }
                    }
                    if (ps.getUpdateCount() != null) {
                        exchange.getOut().setHeader("CamelSqlStoredUpdateCount", ps.getUpdateCount());
                    }
                }
            }
        });
    }

    private StatementWrapper createStatement(Exchange exchange) throws SQLException {
        String templateHeader;
        String sql = this.getEndpoint().isUseMessageBodyForTemplate() ? exchange.getIn().getBody(String.class) : ((templateHeader = exchange.getIn().getHeader("CamelSqlStoredTemplate", String.class)) != null ? templateHeader : this.resolvedTemplate);
        try {
            sql = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), sql, null);
        }
        catch (Exception e) {
            throw new SQLException("Error loading template resource: " + sql, e);
        }
        return this.getEndpoint().getWrapperFactory().create(sql);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        String template = this.getEndpoint().getTemplate();
        if (ResourceHelper.isClasspathUri(template)) {
            this.resolvedTemplate = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), template, null);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        String template = this.getEndpoint().getTemplate();
        if (!ResourceHelper.isClasspathUri(template)) {
            this.resolvedTemplate = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), template, null);
        }
    }
}

