/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.processor.idempotent.jdbc.JdbcMessageIdRepository;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcCachedMessageIdRepository
extends JdbcMessageIdRepository {
    private Map<String, Integer> cache = new HashMap<String, Integer>();
    private int hitCount;
    private int missCount;
    private String queryAllString = "SELECT messageId, COUNT(*) FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? GROUP BY messageId";

    public JdbcCachedMessageIdRepository() {
    }

    public JdbcCachedMessageIdRepository(DataSource dataSource, String processorName) {
        super(dataSource, processorName);
    }

    public JdbcCachedMessageIdRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName) {
        super(dataSource, transactionTemplate, processorName);
    }

    public JdbcCachedMessageIdRepository(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        super(jdbcTemplate, transactionTemplate);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.getTableName() != null) {
            this.queryAllString = this.queryAllString.replaceFirst("CAMEL_MESSAGEPROCESSED", this.getTableName());
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.reload();
    }

    @Override
    public boolean add(String key) {
        Integer previousValue = this.cache.getOrDefault(key, 0);
        this.cache.put(key, previousValue + 1);
        if (previousValue != 0) {
            ++this.hitCount;
            return false;
        }
        ++this.missCount;
        return super.add(key);
    }

    @Override
    public boolean contains(String key) {
        Integer previousValue = this.cache.getOrDefault(key, 0);
        if (previousValue != 0) {
            ++this.hitCount;
            return true;
        }
        ++this.missCount;
        return super.contains(key);
    }

    @Override
    public boolean remove(String key) {
        this.cache.remove(key);
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.hitCount = 0;
        this.missCount = 0;
        super.clear();
    }

    public String getQueryAllString() {
        return this.queryAllString;
    }

    public void setQueryAllString(String queryAllString) {
        this.queryAllString = queryAllString;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getMissCount() {
        return this.missCount;
    }

    public void reload() {
        this.transactionTemplate.execute(status -> {
            try {
                this.cache = this.jdbcTemplate.query(this.getQueryAllString(), resultSet -> {
                    HashMap<String, Integer> messageIdCount = new HashMap<String, Integer>();
                    while (resultSet.next()) {
                        messageIdCount.put(resultSet.getString(1), resultSet.getInt(2));
                    }
                    return messageIdCount;
                }, this.getProcessorName());
                this.log.info("JdbcCachedMessageIdRepository cache loaded with {} entries", (Object)this.cache.size());
            }
            catch (DataAccessException dae) {
                this.log.error("Unable to populate JdbcCachedMessageIdRepository cache because of: {}.", (Object)dae.getMessage());
                throw dae;
            }
            return Boolean.TRUE;
        });
    }
}

