/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SimplePropertySqlParameterSource
extends AbstractSqlParameterSource {
    private static final Object NO_DESCRIPTOR = new Object();
    private final Object paramObject;
    private final Map<String, Object> propertyDescriptors = new ConcurrentHashMap<String, Object>();

    public SimplePropertySqlParameterSource(Object paramObject) {
        Assert.notNull(paramObject, "Parameter object must not be null");
        this.paramObject = paramObject;
    }

    @Override
    public boolean hasValue(String paramName) {
        return this.getDescriptor(paramName) != NO_DESCRIPTOR;
    }

    @Override
    @Nullable
    public Object getValue(String paramName) throws IllegalArgumentException {
        Object desc = this.getDescriptor(paramName);
        if (desc instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)desc;
            ReflectionUtils.makeAccessible(pd.getReadMethod());
            return ReflectionUtils.invokeMethod(pd.getReadMethod(), this.paramObject);
        }
        if (desc instanceof Field) {
            Field field = (Field)desc;
            ReflectionUtils.makeAccessible(field);
            return ReflectionUtils.getField(field, this.paramObject);
        }
        throw new IllegalArgumentException("Cannot retrieve value for parameter '" + paramName + "' - neither a getter method nor a raw field found");
    }

    @Override
    public int getSqlType(String paramName) {
        int sqlType = super.getSqlType(paramName);
        if (sqlType != Integer.MIN_VALUE) {
            return sqlType;
        }
        Object desc = this.getDescriptor(paramName);
        if (desc instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)desc;
            return StatementCreatorUtils.javaTypeToSqlParameterType(pd.getPropertyType());
        }
        if (desc instanceof Field) {
            Field field = (Field)desc;
            return StatementCreatorUtils.javaTypeToSqlParameterType(field.getType());
        }
        return Integer.MIN_VALUE;
    }

    private Object getDescriptor(String paramName) {
        return this.propertyDescriptors.computeIfAbsent(paramName, name -> {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(this.paramObject.getClass(), name);
            if (pd != null && pd.getReadMethod() != null) {
                return pd;
            }
            Field field = ReflectionUtils.findField(this.paramObject.getClass(), name);
            if (field != null) {
                return field;
            }
            return NO_DESCRIPTOR;
        });
    }
}

