/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.lookup;

import java.util.Map;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class IsolationLevelDataSourceRouter
extends AbstractRoutingDataSource {
    static final Map<String, Integer> constants = Map.of("ISOLATION_DEFAULT", -1, "ISOLATION_READ_UNCOMMITTED", 1, "ISOLATION_READ_COMMITTED", 2, "ISOLATION_REPEATABLE_READ", 4, "ISOLATION_SERIALIZABLE", 8);

    @Override
    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        if (lookupKey instanceof Integer) {
            Integer isolationLevel = (Integer)lookupKey;
            Assert.isTrue(constants.containsValue(isolationLevel), "Only values of isolation constants allowed");
            return isolationLevel;
        }
        if (lookupKey instanceof String) {
            String constantName = (String)lookupKey;
            Assert.hasText(constantName, "'lookupKey' must not be null or blank");
            Integer isolationLevel = constants.get(constantName);
            Assert.notNull((Object)isolationLevel, "Only isolation constants allowed");
            return isolationLevel;
        }
        throw new IllegalArgumentException("Invalid lookup key - needs to be isolation level Integer or isolation level name String: " + String.valueOf(lookupKey));
    }

    @Override
    @Nullable
    protected Object determineCurrentLookupKey() {
        return TransactionSynchronizationManager.getCurrentTransactionIsolationLevel();
    }
}

