/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class ResultSetIterator
implements Iterator<Object>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetIterator.class);
    private final Connection connection;
    private final Statement statement;
    private final ResultSet resultSet;
    private final RowMapper<?> rowMapper;
    private final AtomicBoolean closed = new AtomicBoolean();
    private int rowNum;

    public ResultSetIterator(Connection connection, Statement statement, ResultSet resultSet, RowMapper<?> rowMapper) throws SQLException {
        this.connection = connection;
        this.statement = statement;
        this.resultSet = resultSet;
        this.rowMapper = rowMapper;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.closed.get();
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Object next = this.rowMapper.mapRow(this.resultSet, this.rowNum++);
            this.loadNext();
            return next;
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeCamelException("Cannot process result", e);
        }
    }

    private void loadNext() throws SQLException {
        boolean hasNext = this.resultSet.next();
        if (!hasNext) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.safeCloseResultSet();
            this.safeCloseStatement();
            this.safeCloseConnection();
        }
    }

    private void safeCloseResultSet() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            LOG.warn("Error by closing result set: {}", (Object)e, (Object)e);
        }
    }

    private void safeCloseStatement() {
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            LOG.warn("Error by closing statement: {}", (Object)e, (Object)e);
        }
    }

    private void safeCloseConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.warn("Error by closing connection: {}", (Object)e, (Object)e);
        }
    }
}

