/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sql.SqlServiceLocationHelper;
import org.apache.camel.component.sql.stored.CallableStatementWrapperFactory;
import org.apache.camel.component.sql.stored.SqlStoredComponent;
import org.apache.camel.component.sql.stored.SqlStoredConstants;
import org.apache.camel.component.sql.stored.SqlStoredProducer;
import org.apache.camel.component.sql.stored.template.TemplateParser;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.UnwrapHelper;
import org.springframework.jdbc.core.JdbcTemplate;

@UriEndpoint(firstVersion="2.17.0", scheme="sql-stored", title="SQL Stored Procedure", syntax="sql-stored:template", producerOnly=true, category={Category.DATABASE}, headersClass=SqlStoredConstants.class)
public class SqlStoredEndpoint
extends DefaultEndpoint {
    private CallableStatementWrapperFactory wrapperFactory;
    private JdbcTemplate jdbcTemplate;
    private boolean serviceLocationEnabled;
    private String serviceUrl;
    private Map<String, String> serviceMetadata;
    @UriPath(description="Sets the stored procedure template to perform. You can externalize the template by using file: or classpath: as prefix and specify the location of the file.")
    @Metadata(required=true, supportFileReference=true, largeInput=true, inputLanguage="sql")
    private String template;
    @UriParam(description="Sets the DataSource to use to communicate with the database.")
    private DataSource dataSource;
    @UriParam(description="Enables or disables batch mode")
    private boolean batch;
    @UriParam(description="Whether to use the message body as the stored procedure template and then headers for parameters. If this option is enabled then the template in the uri is not used.")
    private boolean useMessageBodyForTemplate;
    @UriParam(description="If set, will ignore the results of the stored procedure template and use the existing IN message as the OUT message for the continuation of processing")
    private boolean noop;
    @UriParam(description="Store the template result in a header instead of the message body. By default, outputHeader == null and the template result is stored in the message body, any existing content in the message body is discarded. If outputHeader is set, the value is used as the name of the header to store the template result and the original message body is preserved.")
    private String outputHeader;
    @UriParam(description="Whether this call is for a function.")
    private boolean function;
    @UriParam(label="advanced", prefix="template.", multiValue=true, description="Configures the Spring JdbcTemplate with the key/values from the Map")
    private Map<String, Object> templateOptions;

    public SqlStoredEndpoint(String uri, SqlStoredComponent component) {
        super(uri, component);
    }

    public SqlStoredEndpoint(String uri, SqlStoredComponent component, JdbcTemplate jdbcTemplate) {
        super(uri, component);
        this.setJdbcTemplate(jdbcTemplate);
    }

    public boolean isServiceLocationEnabled() {
        return this.serviceLocationEnabled;
    }

    public void setServiceLocationEnabled(boolean serviceLocationEnabled) {
        this.serviceLocationEnabled = serviceLocationEnabled;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new SqlStoredProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    @Override
    protected String createEndpointUri() {
        return "sql-stored:" + UnsafeUriCharactersEncoder.encode(this.template);
    }

    protected CallableStatementWrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.wrapperFactory = new CallableStatementWrapperFactory(this.jdbcTemplate, new TemplateParser(this.getCamelContext().getClassResolver()), this.isFunction());
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isServiceLocationEnabled()) {
            DataSource actual;
            BeanIntrospection bi = PluginHelper.getBeanIntrospection(this.getCamelContext());
            DataSource ds = this.getDataSource();
            if (ds != null && ds.getClass().getName().endsWith("ClientProxy") && (actual = UnwrapHelper.unwrapClientProxy(ds)) != null) {
                ds = actual;
            }
            this.serviceUrl = SqlServiceLocationHelper.getJDBCURLFromDataSource(bi, ds);
            this.serviceMetadata = new HashMap<String, String>();
            String user = SqlServiceLocationHelper.getUsernameFromConnectionFactory(bi, ds);
            if (user != null) {
                this.serviceMetadata.put("username", user);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.wrapperFactory != null) {
            this.wrapperFactory.shutdown();
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public boolean isUseMessageBodyForTemplate() {
        return this.useMessageBodyForTemplate;
    }

    public void setUseMessageBodyForTemplate(boolean useMessageBodyForTemplate) {
        this.useMessageBodyForTemplate = useMessageBodyForTemplate;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public String getOutputHeader() {
        return this.outputHeader;
    }

    public void setOutputHeader(String outputHeader) {
        this.outputHeader = outputHeader;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isFunction() {
        return this.function;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    public Map<String, Object> getTemplateOptions() {
        return this.templateOptions;
    }

    public void setTemplateOptions(Map<String, Object> templateOptions) {
        this.templateOptions = templateOptions;
    }
}

