/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.ssh.ResourceBasedSSHKeyVerifier;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.component.ssh.SshHelper;
import org.apache.camel.component.ssh.SshResult;
import org.apache.camel.component.ssh.SshUtils;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.sshd.client.SshClient;

public class SshConsumer
extends ScheduledPollConsumer {
    private final SshEndpoint endpoint;
    private SshClient client;

    public SshConsumer(SshEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        this.client = this.endpoint.getConfiguration() == null || this.endpoint.getConfiguration().getClientBuilder() == null ? SshClient.setUpDefaultClient() : this.endpoint.getConfiguration().getClientBuilder().build(true);
        SshConfiguration configuration = this.endpoint.getConfiguration();
        SshUtils.configureAlgorithms(configuration, this.client);
        this.client.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int poll() throws Exception {
        if (!this.isRunAllowed()) {
            return 0;
        }
        String command = this.endpoint.getPollCommand();
        Exchange exchange = this.createExchange(false);
        try {
            String knownHostResource = this.endpoint.getKnownHostsResource();
            if (knownHostResource != null) {
                this.client.setServerKeyVerifier(new ResourceBasedSSHKeyVerifier(exchange.getContext(), knownHostResource, this.endpoint.isFailOnUnknownHost()));
            }
            SshResult result = SshHelper.sendExecCommand(exchange.getIn().getHeaders(), command, this.endpoint, this.client);
            exchange.getIn().setBody(result.getStdout());
            exchange.getIn().setHeader("CamelSshExitValue", result.getExitValue());
            exchange.getIn().setHeader("CamelSshStderr", result.getStderr());
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
            }
            this.releaseExchange(exchange, false);
        }
    }
}

