/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.util.Optional;
import java.util.function.Function;
import org.apache.camel.util.StringHelper;

public final class SshShellOutputStringHelper {
    private SshShellOutputStringHelper() {
    }

    public static String beforeLast(String text, String before) {
        if (!text.contains(before)) {
            return null;
        }
        return text.substring(0, text.lastIndexOf(before));
    }

    public static <T> Optional<T> beforeLast(String text, String beforeLast, Function<String, T> mapper) {
        String result = SshShellOutputStringHelper.beforeLast(text, beforeLast);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String betweenBeforeLast(String text, String after, String beforeLast) {
        if ((text = StringHelper.after(text, after)) == null) {
            return null;
        }
        return SshShellOutputStringHelper.beforeLast(text, beforeLast);
    }

    public static <T> Optional<T> betweenBeforeLast(String text, String after, String before, Function<String, T> mapper) {
        String result = SshShellOutputStringHelper.betweenBeforeLast(text, after, before);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }
}

