/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.MacFactory;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshUtils.class);

    public static <S> List<NamedFactory<S>> filter(Class<S> type, Collection<NamedFactory<S>> factories, String[] names) {
        ArrayList<NamedFactory<S>> list = new ArrayList<NamedFactory<S>>();
        LOGGER.trace("List of available {} algorithms : {}", (Object)type.getSimpleName().toLowerCase(), (Object)factories.stream().map(NamedResource::getName).collect(Collectors.joining(",")));
        for (String name : names) {
            name = name.trim();
            boolean found = false;
            for (NamedFactory<S> factory : factories) {
                if (!factory.getName().equals(name)) continue;
                list.add(factory);
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.warn("Configured {} '{}' not available", (Object)type.getSimpleName().toLowerCase(), (Object)name);
        }
        return list;
    }

    public static List<KeyExchangeFactory> filter(List<KeyExchangeFactory> factories, String[] names) {
        ArrayList<KeyExchangeFactory> list = new ArrayList<KeyExchangeFactory>();
        LOGGER.info("List of available kex algorithms : {}", (Object)factories.stream().map(NamedResource::getName).collect(Collectors.joining(",")));
        for (String name : names) {
            name = name.trim();
            boolean found = false;
            for (KeyExchangeFactory factory : factories) {
                if (!factory.getName().equals(name)) continue;
                list.add(factory);
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.warn("Configured KeyExchangeFactory '{}' not available", (Object)name);
        }
        return list;
    }

    public static void configureMacs(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank(names)) {
            return;
        }
        Set<BuiltinMacs> builtIn = BuiltinMacs.VALUES;
        NavigableSet<MacFactory> registered = BuiltinMacs.getRegisteredExtensions();
        HashSet<MacFactory> allMacFactories = new HashSet<MacFactory>();
        allMacFactories.addAll(builtIn);
        allMacFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories(false, allMacFactories);
        factoryManager.setMacFactories(SshUtils.filter(Mac.class, avail, names.split(",")));
    }

    public static void configureCiphers(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank(names)) {
            return;
        }
        Set<BuiltinCiphers> builtIn = BuiltinCiphers.VALUES;
        NavigableSet<CipherFactory> registered = BuiltinCiphers.getRegisteredExtensions();
        HashSet<CipherFactory> allCipherFactories = new HashSet<CipherFactory>();
        allCipherFactories.addAll(builtIn);
        allCipherFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories(false, allCipherFactories);
        factoryManager.setCipherFactories(SshUtils.filter(Cipher.class, avail, names.split(",")));
    }

    public static void configureKexAlgorithms(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank(names)) {
            return;
        }
        Set<BuiltinDHFactories> builtin = BuiltinDHFactories.VALUES;
        NavigableSet<DHFactory> dhFactories = BuiltinDHFactories.getRegisteredExtensions();
        HashSet<DHFactory> allDHFactories = new HashSet<DHFactory>();
        allDHFactories.addAll(builtin);
        allDHFactories.addAll(dhFactories);
        List<KeyExchangeFactory> avail = NamedFactory.setUpTransformedFactories(false, builtin, ClientBuilder.DH2KEX);
        factoryManager.setKeyExchangeFactories(SshUtils.filter(avail, names.split(",")));
    }

    public static void configureSignatureAlgorithms(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank(names)) {
            return;
        }
        Set<BuiltinSignatures> builtIn = BuiltinSignatures.VALUES;
        NavigableSet<SignatureFactory> registered = BuiltinSignatures.getRegisteredExtensions();
        HashSet<SignatureFactory> allSignatureFactories = new HashSet<SignatureFactory>();
        allSignatureFactories.addAll(builtIn);
        allSignatureFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories(false, allSignatureFactories);
        factoryManager.setSignatureFactories(SshUtils.filter(Signature.class, avail, names.split(",")));
    }

    public static void configureCompressions(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank(names)) {
            return;
        }
        Set<BuiltinCompressions> builtIn = BuiltinCompressions.VALUES;
        NavigableSet<CompressionFactory> registered = BuiltinCompressions.getRegisteredExtensions();
        HashSet<CompressionFactory> allCompressionFactories = new HashSet<CompressionFactory>();
        allCompressionFactories.addAll(builtIn);
        allCompressionFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories(false, allCompressionFactories);
        factoryManager.setCompressionFactories(SshUtils.filter(Compression.class, avail, names.split(",")));
    }

    public static void configureAlgorithms(SshConfiguration configuration, SshClient client) {
        SshUtils.configureCiphers(configuration.getCiphers(), client);
        SshUtils.configureKexAlgorithms(configuration.getKex(), client);
        SshUtils.configureSignatureAlgorithms(configuration.getSignatures(), client);
        SshUtils.configureMacs(configuration.getMacs(), client);
        SshUtils.configureCompressions(configuration.getCompressions(), client);
    }
}

