/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.sshd.common.kex.KeyEncapsulationMethod;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMExtractor;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMGenerator;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyPairGenerator;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;

final class SNTRUP761 {
    private SNTRUP761() {
    }

    static boolean isSupported() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            return false;
        }
        try {
            return SNTRUPrimeParameters.sntrup761.getSessionKeySize() == 256;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static class Server
    implements KeyEncapsulationMethod.Server {
        private SecretWithEncapsulation value;

        Server() {
        }

        @Override
        public byte[] init(byte[] publicKey) {
            int pkBytes = SNTRUPrimeParameters.sntrup761.getPublicKeyBytes();
            if (publicKey.length < pkBytes) {
                throw new IllegalArgumentException("KEM public key too short: " + publicKey.length);
            }
            byte[] pk = Arrays.copyOf(publicKey, pkBytes);
            SNTRUPrimeKEMGenerator kemGenerator = new SNTRUPrimeKEMGenerator(new SecureRandom());
            SNTRUPrimePublicKeyParameters params = new SNTRUPrimePublicKeyParameters(SNTRUPrimeParameters.sntrup761, pk);
            this.value = kemGenerator.generateEncapsulated(params);
            return Arrays.copyOfRange(publicKey, pkBytes, publicKey.length);
        }

        @Override
        public byte[] getSecret() {
            return this.value.getSecret();
        }

        @Override
        public byte[] getEncapsulation() {
            return this.value.getEncapsulation();
        }
    }

    static class Client
    implements KeyEncapsulationMethod.Client {
        private SNTRUPrimeKEMExtractor extractor;
        private SNTRUPrimePublicKeyParameters publicKey;

        Client() {
        }

        @Override
        public void init() {
            SNTRUPrimeKeyPairGenerator gen = new SNTRUPrimeKeyPairGenerator();
            gen.init(new SNTRUPrimeKeyGenerationParameters(new SecureRandom(), SNTRUPrimeParameters.sntrup761));
            AsymmetricCipherKeyPair pair = gen.generateKeyPair();
            this.extractor = new SNTRUPrimeKEMExtractor((SNTRUPrimePrivateKeyParameters)pair.getPrivate());
            this.publicKey = (SNTRUPrimePublicKeyParameters)pair.getPublic();
        }

        @Override
        public byte[] getPublicKey() {
            return this.publicKey.getEncoded();
        }

        @Override
        public byte[] extractSecret(byte[] encapsulated) {
            if (encapsulated.length != this.extractor.getEncapsulationLength()) {
                throw new IllegalArgumentException("KEM encpsulation has wrong length: " + encapsulated.length);
            }
            return this.extractor.extractSecret(encapsulated);
        }

        @Override
        public int getEncapsulationLength() {
            return this.extractor.getEncapsulationLength();
        }
    }
}

