/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

abstract class PGPDefaultSignatureGenerator {
    protected byte lastb;
    protected OutputStream sigOut;
    protected int sigType;

    PGPDefaultSignatureGenerator() {
    }

    public void update(byte by) {
        if (this.sigType == 1) {
            if (by == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(by);
            }
            this.lastb = by;
        } else {
            this.byteUpdate(by);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.sigType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.blockUpdate(byArray, n, n2);
        }
    }

    private void byteUpdate(byte by) {
        try {
            this.sigOut.write(by);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    protected void blockUpdate(byte[] byArray, int n, int n2) {
        try {
            this.sigOut.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException("unable to update signature: " + iOException.getMessage(), iOException);
        }
    }

    protected void updateWithIdData(int n, byte[] byArray) {
        this.update((byte)n);
        this.update((byte)(byArray.length >> 24));
        this.update((byte)(byArray.length >> 16));
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }

    protected void updateWithPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        return byArray;
    }

    protected void getAttriubtesHash(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) throws PGPException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            UserAttributeSubpacket[] userAttributeSubpacketArray = pGPUserAttributeSubpacketVector.toSubpacketArray();
            for (int i = 0; i != userAttributeSubpacketArray.length; ++i) {
                userAttributeSubpacketArray[i].encode(byteArrayOutputStream);
            }
            this.updateWithIdData(209, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PGPException("cannot encode subpacket array", iOException);
        }
    }
}

