/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xtokenizer;

import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.language.xtokenizer.XMLTokenExpressionIterator;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.IteratorConvertTo;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.builder.Namespaces;

@Language(value="xtokenize")
public class XMLTokenizeLanguage
extends SingleInputTypedLanguageSupport {
    @Override
    protected boolean supportResultType() {
        return false;
    }

    @Override
    public Expression createExpression(Expression source, String expression, Object[] properties) {
        final Class type = this.property(Class.class, properties, 0, null);
        Character mode = this.property(Character.class, properties, 2, "i");
        XMLTokenExpressionIterator xml = new XMLTokenExpressionIterator(source, expression, mode.charValue());
        xml.setGroup(this.property(Integer.TYPE, properties, 3, 1));
        Object obj = properties[4];
        if (obj != null) {
            Namespaces ns;
            if (obj instanceof Namespaces) {
                ns = (Namespaces)obj;
            } else if (obj instanceof Map) {
                ns = new Namespaces();
                ((Map)obj).forEach(ns::add);
            } else {
                throw new IllegalArgumentException("Namespaces is not instance of java.util.Map or " + Namespaces.class.getName());
            }
            xml.setNamespaces(ns.getNamespaces());
        }
        ExpressionAdapter answer = xml;
        if (type != null && type != Object.class) {
            final XMLTokenExpressionIterator delegate = xml;
            answer = new ExpressionAdapter(){

                @Override
                public Object evaluate(Exchange exchange) {
                    Object value = delegate.evaluate(exchange, Object.class);
                    if (value instanceof Iterator) {
                        Iterator it = (Iterator)value;
                        value = new IteratorConvertTo(exchange, it, type);
                    }
                    return value;
                }

                @Override
                public void init(CamelContext context) {
                    super.init(context);
                    delegate.init(context);
                }

                public String toString() {
                    return delegate.toString();
                }
            };
        }
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }
}

