/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch;

import org.apache.camel.CamelContext;
import org.apache.camel.component.stitch.StitchEndpoint;
import org.apache.camel.component.stitch.client.StitchClient;
import org.apache.camel.component.stitch.client.StitchRegion;
import org.apache.camel.component.stitch.client.models.StitchSchema;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public class StitchEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        StitchEndpoint target = (StitchEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "connectionprovider": 
            case "connectionProvider": {
                target.getConfiguration().setConnectionProvider(StitchEndpointConfigurer.property(camelContext, ConnectionProvider.class, value));
                return true;
            }
            case "httpclient": 
            case "httpClient": {
                target.getConfiguration().setHttpClient(StitchEndpointConfigurer.property(camelContext, HttpClient.class, value));
                return true;
            }
            case "keynames": 
            case "keyNames": {
                target.getConfiguration().setKeyNames(StitchEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(StitchEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "region": {
                target.getConfiguration().setRegion(StitchEndpointConfigurer.property(camelContext, StitchRegion.class, value));
                return true;
            }
            case "stitchclient": 
            case "stitchClient": {
                target.getConfiguration().setStitchClient(StitchEndpointConfigurer.property(camelContext, StitchClient.class, value));
                return true;
            }
            case "stitchschema": 
            case "stitchSchema": {
                target.getConfiguration().setStitchSchema(StitchEndpointConfigurer.property(camelContext, StitchSchema.class, value));
                return true;
            }
            case "token": {
                target.getConfiguration().setToken(StitchEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"connectionProvider", "httpClient", "stitchClient", "stitchSchema"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "connectionprovider": 
            case "connectionProvider": {
                return ConnectionProvider.class;
            }
            case "httpclient": 
            case "httpClient": {
                return HttpClient.class;
            }
            case "keynames": 
            case "keyNames": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "region": {
                return StitchRegion.class;
            }
            case "stitchclient": 
            case "stitchClient": {
                return StitchClient.class;
            }
            case "stitchschema": 
            case "stitchSchema": {
                return StitchSchema.class;
            }
            case "token": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        StitchEndpoint target = (StitchEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "connectionprovider": 
            case "connectionProvider": {
                return target.getConfiguration().getConnectionProvider();
            }
            case "httpclient": 
            case "httpClient": {
                return target.getConfiguration().getHttpClient();
            }
            case "keynames": 
            case "keyNames": {
                return target.getConfiguration().getKeyNames();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "region": {
                return target.getConfiguration().getRegion();
            }
            case "stitchclient": 
            case "stitchClient": {
                return target.getConfiguration().getStitchClient();
            }
            case "stitchschema": 
            case "stitchSchema": {
                return target.getConfiguration().getStitchSchema();
            }
            case "token": {
                return target.getConfiguration().getToken();
            }
        }
        return null;
    }
}

