/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.StitchEndpoint;
import org.apache.camel.component.stitch.client.models.StitchResponse;
import org.apache.camel.component.stitch.operations.StitchProducerOperations;
import org.apache.camel.support.DefaultAsyncProducer;

public class StitchProducer
extends DefaultAsyncProducer {
    private StitchProducerOperations operations;

    public StitchProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.operations = new StitchProducerOperations(this.getEndpoint().getStitchClient(), this.getConfiguration());
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.operations.sendEvents(exchange.getMessage(), response -> this.setDataOnExchange((StitchResponse)response, exchange), callback);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    @Override
    public StitchEndpoint getEndpoint() {
        return (StitchEndpoint)super.getEndpoint();
    }

    public StitchConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    private void setDataOnExchange(StitchResponse response, Exchange exchange) {
        Message message = exchange.getIn();
        message.setBody(response.getMessage());
        message.setHeader("CamelStitchCode", response.getHttpStatusCode());
        message.setHeader("CamelStitchStatus", response.getStatus());
        message.setHeader("CamelStitchHeaders", response.getHeaders());
    }
}

