/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.camel.component.stitch.client.JsonUtils;
import org.apache.camel.component.stitch.client.StitchClient;
import org.apache.camel.component.stitch.client.models.StitchError;
import org.apache.camel.component.stitch.client.models.StitchException;
import org.apache.camel.component.stitch.client.models.StitchRequestBody;
import org.apache.camel.component.stitch.client.models.StitchResponse;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientResponse;

public class StitchClientImpl
implements StitchClient {
    private static final String BATCH_API_RESOURCE_URL = "/v2/import/batch";
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String token;

    StitchClientImpl(HttpClient httpClient, String baseUrl, String token) {
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
        this.token = token;
    }

    @Override
    public Mono<StitchResponse> batch(StitchRequestBody requestBody) {
        return this.sendBatch(this.convertMapToByteBuf(requestBody.toMap()));
    }

    @Override
    public void close() {
        ((HttpClientConfig)this.httpClient.configuration()).connectionProvider().disposeLater().block();
    }

    private Mono<StitchResponse> sendBatch(ByteBufMono bodyAsByte) {
        return ((HttpClient.RequestSender)this.httpClient.headers(this.applyHeaders()).baseUrl(this.baseUrl).post().uri(BATCH_API_RESOURCE_URL)).send(bodyAsByte).responseSingle(this::generateStitchResponse);
    }

    private Consumer<? super HttpHeaders> applyHeaders() {
        return h -> {
            h.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("Bearer " + this.token));
            h.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        };
    }

    private ByteBufMono convertMapToByteBuf(Map<String, Object> bodyAsMap) {
        return ByteBufMono.fromString(Mono.just(JsonUtils.convertMapToJson(bodyAsMap)));
    }

    private Mono<StitchResponse> generateStitchResponse(HttpClientResponse clientResponse, ByteBufMono bufMono) {
        int code = this.getStatusCode(clientResponse);
        Map<String, Object> headers = this.getHeaders(clientResponse);
        return bufMono.asString().map(JsonUtils::convertJsonToMap).onErrorReturn(Collections.emptyMap()).handle((bodyMap, sink) -> {
            StitchResponse stitchResponse = this.getStitchResponse(code, headers, (Map<String, Object>)bodyMap);
            if (code >= 300) {
                StitchError stitchError = this.getStitchError((Map<String, Object>)bodyMap);
                sink.error(new StitchException(stitchResponse, stitchError));
            } else {
                sink.next(stitchResponse);
            }
        });
    }

    private int getStatusCode(HttpClientResponse clientResponse) {
        return clientResponse.status().code();
    }

    private Map<String, Object> getHeaders(HttpClientResponse clientResponse) {
        return clientResponse.responseHeaders().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private StitchResponse getStitchResponse(int code, Map<String, Object> headers, Map<String, Object> bodyMap) {
        String status = (String)bodyMap.getOrDefault("status", "");
        String message = (String)bodyMap.getOrDefault("message", "");
        return new StitchResponse(code, headers, status, message);
    }

    private StitchError getStitchError(Map<String, Object> bodyMap) {
        String error = (String)bodyMap.getOrDefault("error", "");
        List<Object> errors = bodyMap.getOrDefault("errors", Collections.emptyList());
        return new StitchError(error, errors);
    }
}

