/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client.models;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.component.stitch.client.models.StitchModel;

public class StitchResponse
implements StitchModel {
    public static final String CODE = "code";
    public static final String HEADERS = "headers";
    public static final String STATUS = "status";
    public static final String MESSAGE = "message";
    private final int httpStatusCode;
    private final Map<String, Object> headers;
    private final String status;
    private final String message;

    public StitchResponse(int httpStatusCode, Map<String, Object> headers, String status, String message) {
        this.httpStatusCode = httpStatusCode;
        this.headers = headers;
        this.status = status;
        this.message = message;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public boolean isOk() {
        return this.httpStatusCode < 300;
    }

    public String toString() {
        return "HTTP Status Code: " + this.httpStatusCode + ", Response Status: " + this.status + ", Response Message: " + this.message;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> resultAsMap = new LinkedHashMap<String, Object>();
        resultAsMap.put(CODE, this.httpStatusCode);
        resultAsMap.put(HEADERS, this.headers);
        resultAsMap.put(STATUS, this.status);
        resultAsMap.put(MESSAGE, this.message);
        return resultAsMap;
    }
}

