/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.StitchEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="stitch")
public class StitchComponent
extends DefaultComponent {
    @Metadata
    private StitchConfiguration configuration = new StitchConfiguration();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        StitchConfiguration configuration = this.configuration != null ? this.configuration.copy() : new StitchConfiguration();
        configuration.setTableName(remaining);
        StitchEndpoint endpoint = new StitchEndpoint(uri, this, configuration);
        this.setProperties(endpoint, parameters);
        this.validateConfigurations(configuration);
        return endpoint;
    }

    public StitchConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(StitchConfiguration configuration) {
        this.configuration = configuration;
    }

    private void validateConfigurations(StitchConfiguration configuration) {
        if (ObjectHelper.isEmpty(configuration.getToken())) {
            throw new IllegalArgumentException("Token must be configured in 'token' option.");
        }
    }
}

