/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.StitchConstants;
import org.apache.camel.component.stitch.StitchProducer;
import org.apache.camel.component.stitch.client.StitchClient;
import org.apache.camel.component.stitch.client.StitchClientBuilder;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.8.0", scheme="stitch", title="Stitch", syntax="stitch:tableName", producerOnly=true, category={Category.CLOUD, Category.API, Category.SAAS, Category.BIGDATA}, headersClass=StitchConstants.class)
public class StitchEndpoint
extends DefaultEndpoint {
    @UriParam
    private StitchConfiguration configuration = new StitchConfiguration();
    private StitchClient stitchClient;

    public StitchEndpoint() {
    }

    public StitchEndpoint(String uri, Component component, StitchConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.stitchClient == null) {
            this.stitchClient = this.configuration.getStitchClient() != null ? this.configuration.getStitchClient() : this.createClient(this.configuration);
        }
    }

    @Override
    public Producer createProducer() throws Exception {
        return new StitchProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Stitch component does not support consumer operations.");
    }

    @Override
    protected void doStop() throws Exception {
        if (ObjectHelper.isEmpty(this.configuration.getStitchClient()) && this.stitchClient != null) {
            this.stitchClient.close();
        }
        super.doStop();
    }

    public StitchConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(StitchConfiguration configuration) {
        this.configuration = configuration;
    }

    public StitchClient getStitchClient() {
        return this.stitchClient;
    }

    public void setStitchClient(StitchClient stitchClient) {
        this.stitchClient = stitchClient;
    }

    private StitchClient createClient(StitchConfiguration configuration) {
        return StitchClientBuilder.builder().withRegion(configuration.getRegion()).withToken(configuration.getToken()).withHttpClient(configuration.getHttpClient()).withConnectionProvider(configuration.getConnectionProvider()).build();
    }
}

