/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch;

import org.apache.camel.CamelContext;
import org.apache.camel.component.stitch.StitchComponent;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.client.StitchClient;
import org.apache.camel.component.stitch.client.StitchRegion;
import org.apache.camel.component.stitch.client.models.StitchSchema;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public class StitchComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private StitchConfiguration getOrCreateConfiguration(StitchComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new StitchConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        StitchComponent target = (StitchComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(StitchComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(StitchComponentConfigurer.property(camelContext, StitchConfiguration.class, value));
                return true;
            }
            case "connectionprovider": 
            case "connectionProvider": {
                this.getOrCreateConfiguration(target).setConnectionProvider(StitchComponentConfigurer.property(camelContext, ConnectionProvider.class, value));
                return true;
            }
            case "httpclient": 
            case "httpClient": {
                this.getOrCreateConfiguration(target).setHttpClient(StitchComponentConfigurer.property(camelContext, HttpClient.class, value));
                return true;
            }
            case "keynames": 
            case "keyNames": {
                this.getOrCreateConfiguration(target).setKeyNames(StitchComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(StitchComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion(StitchComponentConfigurer.property(camelContext, StitchRegion.class, value));
                return true;
            }
            case "stitchclient": 
            case "stitchClient": {
                this.getOrCreateConfiguration(target).setStitchClient(StitchComponentConfigurer.property(camelContext, StitchClient.class, value));
                return true;
            }
            case "stitchschema": 
            case "stitchSchema": {
                this.getOrCreateConfiguration(target).setStitchSchema(StitchComponentConfigurer.property(camelContext, StitchSchema.class, value));
                return true;
            }
            case "token": {
                this.getOrCreateConfiguration(target).setToken(StitchComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"connectionProvider", "httpClient", "stitchClient", "stitchSchema"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return StitchConfiguration.class;
            }
            case "connectionprovider": 
            case "connectionProvider": {
                return ConnectionProvider.class;
            }
            case "httpclient": 
            case "httpClient": {
                return HttpClient.class;
            }
            case "keynames": 
            case "keyNames": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "region": {
                return StitchRegion.class;
            }
            case "stitchclient": 
            case "stitchClient": {
                return StitchClient.class;
            }
            case "stitchschema": 
            case "stitchSchema": {
                return StitchSchema.class;
            }
            case "token": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        StitchComponent target = (StitchComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectionprovider": 
            case "connectionProvider": {
                return this.getOrCreateConfiguration(target).getConnectionProvider();
            }
            case "httpclient": 
            case "httpClient": {
                return this.getOrCreateConfiguration(target).getHttpClient();
            }
            case "keynames": 
            case "keyNames": {
                return this.getOrCreateConfiguration(target).getKeyNames();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "stitchclient": 
            case "stitchClient": {
                return this.getOrCreateConfiguration(target).getStitchClient();
            }
            case "stitchschema": 
            case "stitchSchema": {
                return this.getOrCreateConfiguration(target).getStitchSchema();
            }
            case "token": {
                return this.getOrCreateConfiguration(target).getToken();
            }
        }
        return null;
    }
}

