/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client.models;

import org.apache.camel.component.stitch.client.models.StitchError;
import org.apache.camel.component.stitch.client.models.StitchResponse;

public class StitchException
extends RuntimeException {
    private final StitchResponse response;
    private final StitchError error;

    public StitchException(StitchResponse response, Throwable cause) {
        super(response.getMessage(), cause);
        this.response = response;
        this.error = null;
    }

    public StitchException(StitchResponse response) {
        super(response.getMessage());
        this.response = response;
        this.error = null;
    }

    public StitchException(StitchResponse response, StitchError error, Throwable cause) {
        super(error.getError(), cause);
        this.response = response;
        this.error = error;
    }

    public StitchException(StitchResponse response, StitchError error) {
        super(error.getError());
        this.response = response;
        this.error = error;
    }

    public StitchResponse getResponse() {
        return this.response;
    }

    public StitchError getError() {
        return this.error;
    }
}

