/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.client.StitchClient;
import org.apache.camel.component.stitch.client.models.StitchMessage;
import org.apache.camel.component.stitch.client.models.StitchRequestBody;
import org.apache.camel.component.stitch.client.models.StitchResponse;
import org.apache.camel.component.stitch.client.models.StitchSchema;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StitchProducerOperations {
    private static final Logger LOG = LoggerFactory.getLogger(StitchProducerOperations.class);
    private final StitchClient client;
    private final StitchConfiguration configuration;

    public StitchProducerOperations(StitchClient client, StitchConfiguration configuration) {
        ObjectHelper.notNull(client, "client");
        ObjectHelper.notNull(configuration, "configuration");
        this.client = client;
        this.configuration = configuration;
    }

    public boolean sendEvents(Message inMessage, Consumer<StitchResponse> resultCallback, AsyncCallback callback) {
        this.sendAsyncEvents(inMessage).subscribe(resultCallback, error -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error processing async exchange with error: {}", (Object)error.getMessage());
            }
            inMessage.getExchange().setException((Throwable)error);
            callback.done(false);
        }, () -> {
            LOG.trace("All events with exchange have been sent successfully.");
            callback.done(false);
        });
        return false;
    }

    private Mono<StitchResponse> sendAsyncEvents(Message inMessage) {
        return this.client.batch(this.createStitchRequestBody(inMessage));
    }

    public StitchRequestBody createStitchRequestBody(Message inMessage) {
        if (inMessage.getBody() instanceof StitchRequestBody) {
            return this.createStitchRequestBodyFromStitchRequestBody(inMessage.getBody(StitchRequestBody.class), inMessage);
        }
        if (inMessage.getBody() instanceof StitchMessage) {
            return this.createStitchRequestBodyFromStitchMessages(Collections.singletonList(inMessage.getBody(StitchMessage.class)), inMessage);
        }
        if (inMessage.getBody() instanceof Iterable) {
            return this.createStitchRequestBodyFromIterable(inMessage.getBody(Iterable.class), inMessage);
        }
        if (inMessage.getBody() instanceof Map) {
            return this.createStitchRecordFromMap(inMessage.getBody(Map.class), inMessage);
        }
        throw new IllegalArgumentException("Message body data `" + String.valueOf(inMessage.getBody()) + "` type is not supported");
    }

    private StitchRequestBody createStitchRequestBodyFromStitchRequestBody(StitchRequestBody requestBody, Message message) {
        return this.createStitchRecordFromBuilder(StitchRequestBody.fromStitchRequestBody(requestBody), message);
    }

    private StitchRequestBody createStitchRequestBodyFromStitchMessages(Collection<StitchMessage> stitchMessages, Message message) {
        StitchRequestBody.Builder builder = StitchRequestBody.builder().addMessages(stitchMessages);
        return this.createStitchRecordFromBuilder(builder, message);
    }

    private StitchRequestBody createStitchRequestBodyFromIterable(Iterable<Object> inputData, Message message) {
        LinkedList<StitchMessage> stitchMessages = new LinkedList<StitchMessage>();
        inputData.forEach(data -> {
            if (data instanceof StitchMessage) {
                stitchMessages.add((StitchMessage)data);
            } else if (data instanceof Map) {
                stitchMessages.add(StitchMessage.fromMap(ObjectHelper.cast(Map.class, data)).build());
            } else if (data instanceof StitchRequestBody) {
                stitchMessages.addAll(((StitchRequestBody)data).getMessages());
            } else if (data instanceof Message) {
                Message camelNestedMessage = (Message)data;
                camelNestedMessage.setHeaders(message.getHeaders());
                stitchMessages.addAll(this.createStitchRequestBody(camelNestedMessage).getMessages());
            } else if (data instanceof Exchange) {
                Message camelNestedMessage = ((Exchange)data).getMessage();
                camelNestedMessage.setHeaders(message.getHeaders());
                stitchMessages.addAll(this.createStitchRequestBody(camelNestedMessage).getMessages());
            } else {
                throw new IllegalArgumentException("Input data `" + String.valueOf(data) + "` type is not supported");
            }
        });
        return this.createStitchRequestBodyFromStitchMessages(stitchMessages, message);
    }

    private StitchRequestBody createStitchRecordFromMap(Map<String, Object> data, Message message) {
        return this.createStitchRecordFromBuilder(StitchRequestBody.fromMap(data), message);
    }

    private StitchRequestBody createStitchRecordFromBuilder(StitchRequestBody.Builder builder, Message message) {
        return builder.withSchema(this.getStitchSchema(message)).withTableName(this.getTableName(message)).withKeyNames(this.getKeyNames(message)).build();
    }

    private String getTableName(Message message) {
        return this.getOption(message, "CamelStitchTableName", this.configuration::getTableName, String.class);
    }

    private StitchSchema getStitchSchema(Message message) {
        if (ObjectHelper.isNotEmpty(message.getHeader("CamelStitchSchema"))) {
            if (message.getHeader("CamelStitchSchema") instanceof StitchSchema) {
                return message.getHeader("CamelStitchSchema", StitchSchema.class);
            }
            if (message.getHeader("CamelStitchSchema") instanceof Map) {
                return StitchSchema.builder().addKeywords(message.getHeader("CamelStitchSchema", Map.class)).build();
            }
        }
        return this.configuration.getStitchSchema();
    }

    private Collection<String> getKeyNames(Message message) {
        String keys = this.getOption(message, "CamelStitchKeyNames", this.configuration::getKeyNames, String.class);
        if (ObjectHelper.isNotEmpty(keys)) {
            return Arrays.asList((String[])keys.split(",").clone());
        }
        return Collections.emptyList();
    }

    private <R> R getOption(Message message, String headerName, Supplier<R> fallbackFn, Class<R> type) {
        return ObjectHelper.isEmpty(message) || ObjectHelper.isEmpty(this.getObjectFromHeaders(message, headerName, type)) ? fallbackFn.get() : this.getObjectFromHeaders(message, headerName, type);
    }

    private <T> T getObjectFromHeaders(Message message, String headerName, Class<T> classType) {
        return message.getHeader(headerName, classType);
    }
}

