/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.stomp.StompComponent;
import org.apache.camel.component.stomp.StompConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class StompComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private StompConfiguration getOrCreateConfiguration(StompComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new StompConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        StompComponent target = (StompComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(StompComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(StompComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "brokerurl": 
            case "brokerURL": {
                this.getOrCreateConfiguration(target).setBrokerURL(StompComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(StompComponentConfigurer.property(camelContext, StompConfiguration.class, value));
                return true;
            }
            case "customheaders": 
            case "customHeaders": {
                this.getOrCreateConfiguration(target).setCustomHeaders(StompComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy(StompComponentConfigurer.property(camelContext, HeaderFilterStrategy.class, value));
                return true;
            }
            case "host": {
                this.getOrCreateConfiguration(target).setHost(StompComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(StompComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "login": {
                this.getOrCreateConfiguration(target).setLogin(StompComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "passcode": {
                this.getOrCreateConfiguration(target).setPasscode(StompComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters(StompComponentConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters(StompComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "version": {
                this.getOrCreateConfiguration(target).setVersion(StompComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "brokerurl": 
            case "brokerURL": {
                return String.class;
            }
            case "configuration": {
                return StompConfiguration.class;
            }
            case "customheaders": 
            case "customHeaders": {
                return Properties.class;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return HeaderFilterStrategy.class;
            }
            case "host": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "login": {
                return String.class;
            }
            case "passcode": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return Boolean.TYPE;
            }
            case "version": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        StompComponent target = (StompComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "brokerurl": 
            case "brokerURL": {
                return this.getOrCreateConfiguration(target).getBrokerURL();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "customheaders": 
            case "customHeaders": {
                return this.getOrCreateConfiguration(target).getCustomHeaders();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "host": {
                return this.getOrCreateConfiguration(target).getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "login": {
                return this.getOrCreateConfiguration(target).getLogin();
            }
            case "passcode": {
                return this.getOrCreateConfiguration(target).getPasscode();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "version": {
                return this.getOrCreateConfiguration(target).getVersion();
            }
        }
        return null;
    }
}

