/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.client;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.DefaultTransportListener;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.stomp.client.Callback;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.client.ProtocolException;
import org.fusesource.stomp.codec.StompFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackConnection {
    private final Transport transport;
    private final StompFrame connectedFrame;
    private Callback<StompFrame> receiver;
    private Runnable refiller;
    private final AtomicLong requestCounter = new AtomicLong();
    private HashMap<AsciiBuffer, Callback<StompFrame>> requests = new HashMap();
    private LinkedList<OverflowEntry> overflow = new LinkedList();
    private Throwable failure;

    CallbackConnection(Transport transport, StompFrame connectedFrame) {
        this.transport = transport;
        this.connectedFrame = connectedFrame;
        this.transport.setTransportListener(new DefaultTransportListener(){

            public void onTransportCommand(Object command) {
                CallbackConnection.this.processStompFrame((StompFrame)command);
            }

            public void onRefill() {
                CallbackConnection.this.drainOverflow();
            }

            public void onTransportFailure(IOException error) {
                CallbackConnection.this.processFailure(error);
            }
        });
    }

    public StompFrame connectedFrame() {
        return this.connectedFrame;
    }

    public Transport transport() {
        return this.transport;
    }

    public CallbackConnection refiller(Runnable refiller) {
        this.getDispatchQueue().assertExecuting();
        this.refiller = refiller;
        return this;
    }

    public CallbackConnection receive(Callback<StompFrame> receiver) {
        this.getDispatchQueue().assertExecuting();
        this.receiver = receiver;
        return this;
    }

    private void processStompFrame(StompFrame frame) {
        this.getDispatchQueue().assertExecuting();
        AsciiBuffer action = frame.action();
        if (action.equals(Constants.RECEIPT)) {
            AsciiBuffer id = frame.getHeader(Constants.RECEIPT_ID);
            if (id != null) {
                Callback<StompFrame> cb = this.requests.remove(id);
                if (cb != null) {
                    cb.onSuccess(frame);
                } else if (!this.toReceiver(frame)) {
                    this.processFailure(new ProtocolException("Stomp Response without a valid receipt id: " + id + " for frame " + frame));
                }
            } else {
                this.processFailure(new ProtocolException("Stomp Response with no receipt id: " + frame));
            }
        } else if (action.startsWith(Constants.ERROR)) {
            this.processFailure(new ProtocolException("Received an error: " + frame.errorMessage()));
        } else {
            this.toReceiver(frame);
        }
    }

    private boolean toReceiver(StompFrame frame) {
        if (this.receiver != null) {
            try {
                this.receiver.onSuccess(frame);
            }
            catch (Exception e) {
                this.processFailure(e);
            }
            return true;
        }
        return false;
    }

    private void processFailure(Throwable error) {
        if (this.failure == null) {
            this.failure = error;
            this.failRequests(this.failure);
            if (this.receiver != null) {
                try {
                    this.receiver.onFailure(this.failure);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void failRequests(Throwable failure) {
        ArrayList<Callback<StompFrame>> values = new ArrayList<Callback<StompFrame>>(this.requests.values());
        this.requests.clear();
        for (Callback<StompFrame> value : values) {
            value.onFailure(failure);
        }
        ArrayList<OverflowEntry> overflowEntries = new ArrayList<OverflowEntry>(this.overflow);
        this.overflow.clear();
        for (OverflowEntry entry : overflowEntries) {
            if (entry.cb == null) continue;
            entry.cb.onFailure(failure);
        }
    }

    public DispatchQueue getDispatchQueue() {
        return this.transport.getDispatchQueue();
    }

    public void resume() {
        this.transport.resumeRead();
    }

    public void suspend() {
        this.transport.suspendRead();
    }

    public void close(final Runnable onComplete) {
        this.failRequests(new ClosedChannelException());
        this.transport.stop(new Task(){

            public void run() {
                if (onComplete != null) {
                    onComplete.run();
                }
            }
        });
    }

    public boolean offer(StompFrame frame) {
        return this.offer(frame, true);
    }

    public boolean offer(StompFrame frame, boolean addContentLength) {
        this.getDispatchQueue().assertExecuting();
        if (this.transport.full()) {
            return false;
        }
        if (addContentLength && Constants.SEND.equals(frame.action())) {
            frame.addContentLengthHeader();
        }
        return this.transport.offer(frame);
    }

    public boolean full() {
        this.getDispatchQueue().assertExecuting();
        return this.transport.full();
    }

    public Throwable getFailure() {
        this.getDispatchQueue().assertExecuting();
        return this.failure;
    }

    public AsciiBuffer nextId() {
        return new AsciiBuffer(Long.toString(this.requestCounter.incrementAndGet()));
    }

    public AsciiBuffer nextId(String prefix) {
        return new AsciiBuffer(prefix + this.requestCounter.incrementAndGet());
    }

    public void request(StompFrame frame, Callback<StompFrame> cb) {
        this.getDispatchQueue().assertExecuting();
        assert (cb != null) : "Callback must not be null";
        if (this.failure != null) {
            cb.onFailure(this.failure);
        } else {
            AsciiBuffer id = this.nextId();
            this.requests.put(id, cb);
            frame.addHeader(Constants.RECEIPT_REQUESTED, id);
            this.send(frame, null);
        }
    }

    private void drainOverflow() {
        OverflowEntry entry;
        this.getDispatchQueue().assertExecuting();
        if (this.overflow.isEmpty()) {
            return;
        }
        while ((entry = this.overflow.peek()) != null && this.offer(entry.frame)) {
            this.overflow.removeFirst();
            if (entry.cb == null) continue;
            entry.cb.onSuccess(null);
        }
        if (this.overflow.isEmpty() && this.refiller != null) {
            try {
                this.refiller.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void send(StompFrame frame, Callback<Void> cb) {
        this.getDispatchQueue().assertExecuting();
        if (this.failure != null) {
            if (cb != null) {
                cb.onFailure(this.failure);
            }
        } else if (this.overflow.isEmpty() && this.offer(frame)) {
            if (cb != null) {
                cb.onSuccess(null);
            }
        } else {
            this.overflow.addLast(new OverflowEntry(frame, cb));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OverflowEntry {
        final StompFrame frame;
        final Callback<Void> cb;

        OverflowEntry(StompFrame frame, Callback<Void> cb) {
            this.cb = cb;
            this.frame = frame;
        }
    }
}

