/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.message;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.stomp.jms.message.StompJmsMessage;
import org.fusesource.stomp.jms.util.StompTranslator;

public class StompJmsObjectMessage
extends StompJmsMessage
implements ObjectMessage {
    protected transient Serializable object;

    public StompJmsMessage.JmsMsgType getMsgType() {
        return StompJmsMessage.JmsMsgType.OBJECT;
    }

    public StompJmsMessage copy() throws JMSException {
        StompJmsObjectMessage other = new StompJmsObjectMessage();
        other.copy(this);
        return other;
    }

    private void copy(StompJmsObjectMessage other) throws JMSException {
        other.storeContent();
        super.copy(other);
        this.object = null;
    }

    public void storeContent() throws JMSException {
        Buffer buffer = this.getContent();
        if (buffer == null && this.object != null) {
            this.setContent(StompTranslator.writeBufferFromObject(this.object));
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.object = null;
    }

    public void setObject(Serializable newObject) throws JMSException {
        this.checkReadOnlyBody();
        this.object = newObject;
        this.setContent(null);
        this.storeContent();
    }

    public Serializable getObject() throws JMSException {
        Buffer buffer = this.getContent();
        if (this.object == null && buffer != null) {
            this.object = (Serializable)StompTranslator.readObjectFromBuffer(buffer);
        }
        return this.object;
    }

    public String toString() {
        try {
            this.getObject();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return super.toString();
    }
}

