/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SecuredSession;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportFilter;
import org.fusesource.hawtdispatch.transport.WrappingProtocolCodec;

public class SslProtocolCodec
implements WrappingProtocolCodec,
SecuredSession {
    private ReadableByteChannel readChannel;
    private WritableByteChannel writeChannel;
    private SSLContext sslContext;
    private SSLEngine engine;
    private ByteBuffer readBuffer;
    private boolean readUnderflow;
    private ByteBuffer writeBuffer;
    private boolean writeFlushing;
    private ByteBuffer readOverflowBuffer;
    Transport transport;
    int lastReadSize;
    int lastWriteSize;
    long readCounter;
    long writeCounter;
    ProtocolCodec next;
    SSLReadChannel sslReadChannel = new SSLReadChannel();
    SSLWriteChannel sslWriteChannel = new SSLWriteChannel();

    public ProtocolCodec getNext() {
        return this.next;
    }

    public void setNext(ProtocolCodec next) {
        this.next = next;
        this.initNext();
    }

    private void initNext() {
        if (this.next != null) {
            this.next.setTransport(new TransportFilter(this.transport){

                public ReadableByteChannel getReadChannel() {
                    return SslProtocolCodec.this.sslReadChannel;
                }

                public WritableByteChannel getWriteChannel() {
                    return SslProtocolCodec.this.sslWriteChannel;
                }
            });
        }
    }

    public void setSSLContext(SSLContext ctx) {
        assert (this.engine == null);
        this.sslContext = ctx;
    }

    public SslProtocolCodec client() throws Exception {
        this.initializeEngine();
        this.engine.setUseClientMode(true);
        this.engine.beginHandshake();
        return this;
    }

    public SslProtocolCodec server(ClientAuth clientAuth) throws Exception {
        this.initializeEngine();
        this.engine.setUseClientMode(false);
        switch (clientAuth) {
            case WANT: {
                this.engine.setWantClientAuth(true);
                break;
            }
            case NEED: {
                this.engine.setNeedClientAuth(true);
                break;
            }
            case NONE: {
                this.engine.setWantClientAuth(false);
            }
        }
        this.engine.beginHandshake();
        return this;
    }

    protected void initializeEngine() throws Exception {
        assert (this.engine == null);
        if (this.sslContext == null) {
            this.sslContext = SSLContext.getDefault();
        }
        this.engine = this.sslContext.createSSLEngine();
        SSLSession session = this.engine.getSession();
        this.readBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        this.readBuffer.flip();
        this.writeBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
    }

    public SSLSession getSSLSession() {
        return this.engine == null ? null : this.engine.getSession();
    }

    public X509Certificate[] getPeerX509Certificates() {
        if (this.engine == null) {
            return null;
        }
        try {
            ArrayList<X509Certificate> rc = new ArrayList<X509Certificate>();
            for (Certificate c : this.engine.getSession().getPeerCertificates()) {
                if (!(c instanceof X509Certificate)) continue;
                rc.add((X509Certificate)c);
            }
            return rc.toArray(new X509Certificate[rc.size()]);
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
        this.readChannel = transport.getReadChannel();
        this.writeChannel = transport.getWriteChannel();
        this.initNext();
    }

    public void handshake() throws IOException {
        if (!this.transportFlush()) {
            return;
        }
        switch (this.engine.getHandshakeStatus()) {
            case NEED_TASK: {
                final Runnable task = this.engine.getDelegatedTask();
                if (task == null) break;
                this.transport.getBlockingExecutor().execute(new Task(){

                    public void run() {
                        task.run();
                        SslProtocolCodec.this.transport.getDispatchQueue().execute(new Task(){

                            public void run() {
                                if (SslProtocolCodec.this.readChannel.isOpen() && SslProtocolCodec.this.writeChannel.isOpen()) {
                                    try {
                                        SslProtocolCodec.this.handshake();
                                    }
                                    catch (IOException e) {
                                        SslProtocolCodec.this.transport.getTransportListener().onTransportFailure(e);
                                    }
                                }
                            }
                        });
                    }
                });
                break;
            }
            case NEED_WRAP: {
                this.secure_write(ByteBuffer.allocate(0));
                break;
            }
            case NEED_UNWRAP: {
                if (this.secure_read(ByteBuffer.allocate(0)) != -1) break;
                throw new EOFException("Peer disconnected during ssl handshake");
            }
            case FINISHED: 
            case NOT_HANDSHAKING: {
                this.transport.drainInbound();
                this.transport.getTransportListener().onRefill();
                break;
            }
            default: {
                System.err.println("Unexpected ssl engine handshake status: " + (Object)((Object)this.engine.getHandshakeStatus()));
            }
        }
    }

    protected boolean transportFlush() throws IOException {
        while (true) {
            if (this.writeFlushing) {
                this.lastWriteSize = this.writeChannel.write(this.writeBuffer);
                if (this.lastWriteSize > 0) {
                    this.writeCounter += (long)this.lastWriteSize;
                }
                if (!this.writeBuffer.hasRemaining()) {
                    this.writeBuffer.clear();
                    this.writeFlushing = false;
                    return true;
                }
                return false;
            }
            if (this.writeBuffer.position() == 0) break;
            this.writeBuffer.flip();
            this.writeFlushing = true;
        }
        return true;
    }

    private int secure_read(ByteBuffer plain) throws IOException {
        int rc = 0;
        while (plain.hasRemaining() ^ this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.readOverflowBuffer != null) {
                if (plain.hasRemaining()) {
                    int size = Math.min(plain.remaining(), this.readOverflowBuffer.remaining());
                    plain.put(this.readOverflowBuffer.array(), this.readOverflowBuffer.position(), size);
                    this.readOverflowBuffer.position(this.readOverflowBuffer.position() + size);
                    if (!this.readOverflowBuffer.hasRemaining()) {
                        this.readOverflowBuffer = null;
                    }
                    rc += size;
                    continue;
                }
                return rc;
            }
            if (this.readUnderflow) {
                this.lastReadSize = this.readChannel.read(this.readBuffer);
                if (this.lastReadSize == -1) {
                    if (rc == 0) {
                        return -1;
                    }
                    return rc;
                }
                if (this.lastReadSize == 0) {
                    return rc;
                }
                this.readCounter += (long)this.lastReadSize;
                this.readUnderflow = false;
                this.readBuffer.flip();
                continue;
            }
            SSLEngineResult result = this.engine.unwrap(this.readBuffer, plain);
            rc += result.bytesProduced();
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.readOverflowBuffer = ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize());
                result = this.engine.unwrap(this.readBuffer, this.readOverflowBuffer);
                if (this.readOverflowBuffer.position() == 0) {
                    this.readOverflowBuffer = null;
                } else {
                    this.readOverflowBuffer.flip();
                }
            }
            switch (result.getStatus()) {
                case CLOSED: {
                    if (rc == 0) {
                        this.engine.closeInbound();
                        return -1;
                    }
                    return rc;
                }
                case OK: {
                    if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
                    this.handshake();
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    this.readBuffer.compact();
                    this.readUnderflow = true;
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new AssertionError((Object)"Unexpected case.");
                }
            }
        }
        return rc;
    }

    private int secure_write(ByteBuffer plain) throws IOException {
        if (!this.transportFlush()) {
            return 0;
        }
        int rc = 0;
        while (plain.hasRemaining() ^ this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            SSLEngineResult result = this.engine.wrap(plain, this.writeBuffer);
            assert (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW);
            rc += result.bytesConsumed();
            if (this.transportFlush()) continue;
            break;
        }
        if (plain.remaining() == 0 && this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshake();
        }
        return rc;
    }

    public void unread(byte[] buffer) {
        this.readBuffer.compact();
        if (this.readBuffer.remaining() < buffer.length) {
            throw new IllegalStateException("Cannot unread now");
        }
        this.readBuffer.put(buffer);
        this.readBuffer.flip();
    }

    public Object read() throws IOException {
        return this.next.read();
    }

    public ProtocolCodec.BufferState write(Object value) throws IOException {
        return this.next.write(value);
    }

    public ProtocolCodec.BufferState flush() throws IOException {
        return this.next.flush();
    }

    public boolean full() {
        return this.next.full();
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    public long getLastWriteSize() {
        return this.lastWriteSize;
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    public long getLastReadSize() {
        return this.lastReadSize;
    }

    public int getReadBufferSize() {
        return this.readBuffer.capacity();
    }

    public int getWriteBufferSize() {
        return this.writeBuffer.capacity();
    }

    public class SSLWriteChannel
    implements GatheringByteChannel {
        public int write(ByteBuffer plain) throws IOException {
            if (SslProtocolCodec.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                SslProtocolCodec.this.handshake();
            }
            return SslProtocolCodec.this.secure_write(plain);
        }

        public boolean isOpen() {
            return SslProtocolCodec.this.writeChannel.isOpen();
        }

        public void close() throws IOException {
            SslProtocolCodec.this.writeChannel.close();
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (offset + length > srcs.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer src = srcs[offset + i];
                if (src.hasRemaining()) {
                    rc += (long)this.write(src);
                }
                if (!src.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }
    }

    public class SSLReadChannel
    implements ScatteringByteChannel {
        public int read(ByteBuffer plain) throws IOException {
            if (SslProtocolCodec.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                SslProtocolCodec.this.handshake();
            }
            return SslProtocolCodec.this.secure_read(plain);
        }

        public boolean isOpen() {
            return SslProtocolCodec.this.readChannel.isOpen();
        }

        public void close() throws IOException {
            SslProtocolCodec.this.readChannel.close();
        }

        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (offset + length > dsts.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer dst = dsts[offset + i];
                if (dst.hasRemaining()) {
                    rc += (long)this.read(dst);
                }
                if (!dst.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientAuth {
        WANT,
        NEED,
        NONE;

    }
}

