/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.message;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.message.StompJmsMessage;

public class StompJmsBytesMessage
extends StompJmsMessage
implements BytesMessage {
    protected transient DataByteArrayOutputStream bytesOut;
    protected transient DataInputStream dataIn;
    protected transient int length;

    public StompJmsMessage.JmsMsgType getMsgType() {
        return StompJmsMessage.JmsMsgType.BYTES;
    }

    public StompJmsMessage copy() throws JMSException {
        StompJmsBytesMessage other = new StompJmsBytesMessage();
        other.copy(this);
        return other;
    }

    private void copy(StompJmsBytesMessage other) throws JMSException {
        other.storeContent();
        super.copy(other);
        this.bytesOut = null;
        this.dataIn = null;
    }

    public void storeContent() throws JMSException {
        try {
            if (this.bytesOut != null) {
                this.bytesOut.close();
                Buffer bs = this.bytesOut.toBuffer();
                this.setContent(bs);
                this.bytesOut = null;
            }
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataIn = null;
        this.bytesOut = null;
    }

    public long getBodyLength() throws JMSException {
        this.initializeReading();
        return this.length;
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readBoolean();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readShort();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readChar();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readInt();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readLong();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readFloat();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readDouble();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUTF();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.initializeReading();
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeBoolean(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeByte(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeShort(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeChar(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeInt(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeLong(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeFloat(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeDouble(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.writeUTF(value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.write(value);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.bytesOut.write(value, offset, length);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void reset() throws JMSException {
        this.storeContent();
        this.bytesOut = null;
        this.dataIn = null;
        this.setReadOnlyBody(true);
    }

    private void initializeWriting() throws JMSException {
        this.checkReadOnlyBody();
        if (this.bytesOut == null) {
            this.bytesOut = new DataByteArrayOutputStream();
        }
    }

    protected void checkWriteOnlyBody() throws MessageNotReadableException {
        if (!this.readOnlyBody) {
            throw new MessageNotReadableException("Message body is write-only");
        }
    }

    private void initializeReading() throws JMSException {
        this.checkWriteOnlyBody();
        if (this.dataIn == null) {
            Buffer buffer = this.getContent();
            if (buffer == null) {
                buffer = new Buffer(0);
            }
            this.dataIn = new DataInputStream(new ByteArrayInputStream(buffer));
            this.length = buffer.getLength();
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.initializeWriting();
        super.setObjectProperty(name, value);
    }

    public String toString() {
        return super.toString() + " StompJmsBytesMessage{ " + "bytesOut = " + this.bytesOut + ", dataIn = " + this.dataIn + " }";
    }
}

