/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.nio.charset.Charset;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.stream.DefaultGroupStrategy;
import org.apache.camel.component.stream.GroupStrategy;
import org.apache.camel.component.stream.StreamConstants;
import org.apache.camel.component.stream.StreamConsumer;
import org.apache.camel.component.stream.StreamProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.3.0", scheme="stream", title="Stream", syntax="stream:kind", category={Category.FILE, Category.CORE}, headersClass=StreamConstants.class)
public class StreamEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(StreamEndpoint.class);
    private transient Charset charset;
    @UriPath(enums="in,out,err,header,file,http")
    @Metadata(required=true)
    private String kind;
    @UriParam
    private String fileName;
    @UriParam(label="consumer")
    private String httpUrl;
    @UriParam(label="consumer")
    private String httpHeaders;
    @UriParam(label="consumer")
    private boolean scanStream;
    @UriParam(label="consumer")
    private boolean retry;
    @UriParam(label="consumer")
    private boolean fileWatcher;
    @UriParam(label="producer")
    private boolean closeOnDone;
    @UriParam(label="consumer")
    private long scanStreamDelay;
    @UriParam(label="producer")
    private long delay;
    @UriParam
    private String encoding;
    @UriParam(label="consumer")
    private String promptMessage;
    @UriParam(label="consumer")
    private long promptDelay;
    @UriParam(label="consumer", defaultValue="2000")
    private long initialPromptDelay = 2000L;
    @UriParam(label="consumer")
    private int groupLines;
    @UriParam(label="consumer", defaultValue="true")
    private boolean readLine = true;
    @UriParam(label="producer", defaultValue="true")
    private boolean appendNewLine = true;
    @UriParam(label="producer")
    private int autoCloseCount;
    @UriParam(label="consumer")
    private GroupStrategy groupStrategy = new DefaultGroupStrategy();
    @UriParam(label="advanced")
    private int readTimeout;

    public StreamEndpoint(String endpointUri, Component component) throws Exception {
        super(endpointUri, component);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        StreamConsumer answer = new StreamConsumer(this, processor, this.getEndpointUri());
        if (this.isFileWatcher() && !"file".equals(this.getKind())) {
            throw new IllegalArgumentException("File watcher is only possible if reading streams from files");
        }
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new StreamProducer(this, this.getEndpointUri());
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public String getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(String httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPromptMessage() {
        return this.promptMessage;
    }

    public void setPromptMessage(String promptMessage) {
        this.promptMessage = promptMessage;
    }

    public long getPromptDelay() {
        return this.promptDelay;
    }

    public void setPromptDelay(long promptDelay) {
        this.promptDelay = promptDelay;
    }

    public long getInitialPromptDelay() {
        return this.initialPromptDelay;
    }

    public void setInitialPromptDelay(long initialPromptDelay) {
        this.initialPromptDelay = initialPromptDelay;
    }

    public boolean isScanStream() {
        return this.scanStream;
    }

    public void setScanStream(boolean scanStream) {
        this.scanStream = scanStream;
    }

    public GroupStrategy getGroupStrategy() {
        return this.groupStrategy;
    }

    public void setGroupStrategy(GroupStrategy strategy) {
        this.groupStrategy = strategy;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public boolean isFileWatcher() {
        return this.fileWatcher;
    }

    public void setFileWatcher(boolean fileWatcher) {
        this.fileWatcher = fileWatcher;
    }

    public boolean isCloseOnDone() {
        return this.closeOnDone;
    }

    public void setCloseOnDone(boolean closeOnDone) {
        this.closeOnDone = closeOnDone;
    }

    public long getScanStreamDelay() {
        return this.scanStreamDelay;
    }

    public void setScanStreamDelay(long scanStreamDelay) {
        this.scanStreamDelay = scanStreamDelay;
    }

    public int getGroupLines() {
        return this.groupLines;
    }

    public void setGroupLines(int groupLines) {
        this.groupLines = groupLines;
    }

    public boolean isReadLine() {
        return this.readLine;
    }

    public void setReadLine(boolean readLine) {
        this.readLine = readLine;
    }

    public int getAutoCloseCount() {
        return this.autoCloseCount;
    }

    public void setAutoCloseCount(int autoCloseCount) {
        this.autoCloseCount = autoCloseCount;
    }

    public boolean isAppendNewLine() {
        return this.appendNewLine;
    }

    public void setAppendNewLine(boolean appendNewLine) {
        this.appendNewLine = appendNewLine;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.charset = this.loadCharset();
    }

    Charset loadCharset() {
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().name();
            LOG.debug("No encoding parameter using default charset: {}", (Object)this.encoding);
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding);
    }
}

